<html><pre><?php
# Copyright (c) 2001  David Muse
# See the file COPYING for more information.

dl("sql_relay.so");

function checkSuccess($value,$success) {

	if ($value==$success) {
		echo("success ");
	} else {
		echo("failure ");
		sqlrcur_free($cur);
		sqlrcon_free($con);
		exit(0);
	}
}

	$host=$_REQUEST["host"];
	$port=$_REQUEST["port"];
	$socket=$_REQUEST["socket"];
	$user=$_REQUEST["user"];
	$password=$_REQUEST["password"];

	# instantiation
	$con=sqlrcon_alloc($host,$port,$socket,$user,$password,0,1);
	$cur=sqlrcur_alloc($con);

	# get database type
	echo("IDENTIFY: \n");
	checkSuccess(sqlrcon_identify($con),"lago");
	echo("\n");

	# ping
	echo("PING: \n");
	checkSuccess(sqlrcon_ping($con),1);
	echo("\n");

	# drop existing table
	sqlrcur_sendQuery($cur,"drop table testtable");

	echo("CREATE TEMPTABLE: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable (testsmallint smallint, testint int, testfloat float, testdouble double, testdecimal decimal(1,1), testchar char(40), testvarchar varchar(40), testdate date, testtime time, testtimestamp timestamp)"),1);
	echo("\n");

	echo("INSERT: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable (testsmallint, testint, testfloat, testdouble, testdecimal, testchar, testvarchar, testdate, testtime) values (1,1,1.1,1.1,1.1,'testchar1','testvarchar1','20010101','010000')"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable (testsmallint, testint, testfloat, testdouble, testdecimal, testchar, testvarchar, testdate, testtime) values (2,2,2.1,2.1,2.1,'testchar2','testvarchar2','20020101','020000')"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable (testsmallint, testint, testfloat, testdouble, testdecimal, testchar, testvarchar, testdate, testtime) values (3,3,3.1,3.1,3.1,'testchar3','testvarchar3','20030101','030000')"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable (testsmallint, testint, testfloat, testdouble, testdecimal, testchar, testvarchar, testdate, testtime) values (4,4,4.1,4.1,4.1,'testchar4','testvarchar4','20040101','040000')"),1);
	echo("\n");

	echo("AFFECTED ROWS: \n");
	checkSuccess(sqlrcur_affectedRows($cur),-1);
	echo("\n");

	echo("BIND BY NAME: \n");
	sqlrcur_prepareQuery($cur,"insert into testtable (testsmallint, testint, testfloat, testdouble, testdecimal, testchar, testvarchar, testdate, testtime) values (:var1,:var2,:var3,:var4,:var5,:var6,:var7,:var8,:var9)");
	checkSuccess(sqlrcur_countBindVariables($cur),9);
	sqlrcur_inputBind($cur,"var1",5);
	sqlrcur_inputBind($cur,"var2",5);
	sqlrcur_inputBind($cur,"var3",5.1,2,1);
	sqlrcur_inputBind($cur,"var4",5.1,2,1);
	sqlrcur_inputBind($cur,"var5",5.1,2,1);
	sqlrcur_inputBind($cur,"var6","testchar5");
	sqlrcur_inputBind($cur,"var7","testvarchar5");
	sqlrcur_inputBind($cur,"var8","20050101");
	sqlrcur_inputBind($cur,"var9","050000");
	checkSuccess(sqlrcur_executeQuery($cur),1);
	sqlrcur_clearBinds($cur);
	sqlrcur_inputBind($cur,"var1",6);
	sqlrcur_inputBind($cur,"var2",6);
	sqlrcur_inputBind($cur,"var3",6.1,2,1);
	sqlrcur_inputBind($cur,"var4",6.1,2,1);
	sqlrcur_inputBind($cur,"var5",6.1,2,1);
	sqlrcur_inputBind($cur,"var6","testchar6");
	sqlrcur_inputBind($cur,"var7","testvarchar6");
	sqlrcur_inputBind($cur,"var8","20060101");
	sqlrcur_inputBind($cur,"var9","060000");
	checkSuccess(sqlrcur_executeQuery($cur),1);

	echo("ARRAY BIND BY NAME: \n");
	sqlrcur_clearBinds($cur);
	$bindvars=array("var1","var2","var3","var4","var5","var6","var7","var8","var9");
	$bindvals=array(7,7,7.1,7.1,7.1,"testchar7","testvarchar7","20070101","070000");
	$precs=array(0,0,2,2,2,0,0,0,0);
	$scales=array(0,0,1,1,1,0,0,0,0);
	sqlrcur_inputBinds($cur,$bindvars,$bindvals,$precs,$scales);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("BIND BY NAME WITH VALIDATION: \n");
	sqlrcur_clearBinds($cur);
	sqlrcur_inputBind($cur,"var1",8);
	sqlrcur_inputBind($cur,"var2",8);
	sqlrcur_inputBind($cur,"var3",8.1,2,1);
	sqlrcur_inputBind($cur,"var4",8.1,2,1);
	sqlrcur_inputBind($cur,"var5",8.1,2,1);
	sqlrcur_inputBind($cur,"var6","testchar8");
	sqlrcur_inputBind($cur,"var7","testvarchar8");
	sqlrcur_inputBind($cur,"var8","20080101");
	sqlrcur_inputBind($cur,"var9","080000");
	sqlrcur_inputBind($cur,"var10","junkvalue");
	sqlrcur_validateBinds($cur);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("SELECT: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	echo("\n");

	echo("COLUMN COUNT: \n");
	checkSuccess(sqlrcur_colCount($cur),10);
	echo("\n");

	echo("COLUMN NAMES: \n");
	checkSuccess(sqlrcur_getColumnName($cur,0),"testsmallint");
	checkSuccess(sqlrcur_getColumnName($cur,1),"testint");
	checkSuccess(sqlrcur_getColumnName($cur,2),"testfloat");
	checkSuccess(sqlrcur_getColumnName($cur,3),"testdouble");
	checkSuccess(sqlrcur_getColumnName($cur,4),"testdecimal");
	checkSuccess(sqlrcur_getColumnName($cur,5),"testchar");
	checkSuccess(sqlrcur_getColumnName($cur,6),"testvarchar");
	checkSuccess(sqlrcur_getColumnName($cur,7),"testdate");
	checkSuccess(sqlrcur_getColumnName($cur,8),"testtime");
	checkSuccess(sqlrcur_getColumnName($cur,9),"testtimestamp");
	$cols=sqlrcur_getColumnNames($cur);
	checkSuccess($cols[0],"testsmallint");
	checkSuccess($cols[1],"testint");
	checkSuccess($cols[2],"testfloat");
	checkSuccess($cols[3],"testdouble");
	checkSuccess($cols[4],"testdecimal");
	checkSuccess($cols[5],"testchar");
	checkSuccess($cols[6],"testvarchar");
	checkSuccess($cols[7],"testdate");
	checkSuccess($cols[8],"testtime");
	checkSuccess($cols[9],"testtimestamp");
	echo("\n");

	echo("COLUMN TYPES: \n");
	checkSuccess(sqlrcur_getColumnType($cur,0),"SMALLINT");
	checkSuccess(sqlrcur_getColumnType($cur,"testsmallint"),"SMALLINT");
	checkSuccess(sqlrcur_getColumnType($cur,1),"INT");
	checkSuccess(sqlrcur_getColumnType($cur,"testint"),"INT");
	checkSuccess(sqlrcur_getColumnType($cur,2),"FLOAT");
	checkSuccess(sqlrcur_getColumnType($cur,"testfloat"),"FLOAT");
	checkSuccess(sqlrcur_getColumnType($cur,3),"DOUBLE");
	checkSuccess(sqlrcur_getColumnType($cur,"testdouble"),"DOUBLE");
	checkSuccess(sqlrcur_getColumnType($cur,4),"DOUBLE");
	checkSuccess(sqlrcur_getColumnType($cur,"testdecimal"),"DOUBLE");
	checkSuccess(sqlrcur_getColumnType($cur,5),"CHAR");
	checkSuccess(sqlrcur_getColumnType($cur,"testchar"),"CHAR");
	checkSuccess(sqlrcur_getColumnType($cur,6),"VARCHAR");
	checkSuccess(sqlrcur_getColumnType($cur,"testvarchar"),"VARCHAR");
	checkSuccess(sqlrcur_getColumnType($cur,7),"DATE");
	checkSuccess(sqlrcur_getColumnType($cur,"testdate"),"DATE");
	checkSuccess(sqlrcur_getColumnType($cur,8),"TIME");
	checkSuccess(sqlrcur_getColumnType($cur,"testtime"),"TIME");
	checkSuccess(sqlrcur_getColumnType($cur,9),"TIMESTAMP");
	checkSuccess(sqlrcur_getColumnType($cur,"testtimestamp"),"TIMESTAMP");
	echo("\n");

	echo("COLUMN LENGTH: \n");
	checkSuccess(sqlrcur_getColumnLength($cur,0),2);
	checkSuccess(sqlrcur_getColumnLength($cur,"testsmallint"),2);
	checkSuccess(sqlrcur_getColumnLength($cur,1),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testint"),4);
	checkSuccess(sqlrcur_getColumnLength($cur,2),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testfloat"),4);
	checkSuccess(sqlrcur_getColumnLength($cur,3),8);
	checkSuccess(sqlrcur_getColumnLength($cur,"testdouble"),8);
	checkSuccess(sqlrcur_getColumnLength($cur,4),8);
	checkSuccess(sqlrcur_getColumnLength($cur,"testdecimal"),8);
	checkSuccess(sqlrcur_getColumnLength($cur,5),40);
	checkSuccess(sqlrcur_getColumnLength($cur,"testchar"),40);
	checkSuccess(sqlrcur_getColumnLength($cur,6),40);
	checkSuccess(sqlrcur_getColumnLength($cur,"testvarchar"),40);
	checkSuccess(sqlrcur_getColumnLength($cur,7),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testdate"),4);
	checkSuccess(sqlrcur_getColumnLength($cur,8),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtime"),4);
	checkSuccess(sqlrcur_getColumnLength($cur,9),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtimestamp"),4);
	echo("\n");

	echo("LONGEST COLUMN: \n");
	checkSuccess(sqlrcur_getLongest($cur,0),1);
	checkSuccess(sqlrcur_getLongest($cur,"testsmallint"),1);
	checkSuccess(sqlrcur_getLongest($cur,1),1);
	checkSuccess(sqlrcur_getLongest($cur,"testint"),1);
	checkSuccess(sqlrcur_getLongest($cur,2),3);
	checkSuccess(sqlrcur_getLongest($cur,"testfloat"),3);
	checkSuccess(sqlrcur_getLongest($cur,3),3);
	checkSuccess(sqlrcur_getLongest($cur,"testdouble"),3);
	checkSuccess(sqlrcur_getLongest($cur,4),3);
	checkSuccess(sqlrcur_getLongest($cur,"testdecimal"),3);
	checkSuccess(sqlrcur_getLongest($cur,5),40);
	checkSuccess(sqlrcur_getLongest($cur,"testchar"),40);
	checkSuccess(sqlrcur_getLongest($cur,6),12);
	checkSuccess(sqlrcur_getLongest($cur,"testvarchar"),12);
	checkSuccess(sqlrcur_getLongest($cur,7),11);
	checkSuccess(sqlrcur_getLongest($cur,"testdate"),11);
	checkSuccess(sqlrcur_getLongest($cur,8),8);
	checkSuccess(sqlrcur_getLongest($cur,"testtime"),8);
	echo("\n");

	echo("ROW COUNT: \n");
	checkSuccess(sqlrcur_rowCount($cur),8);
	echo("\n");

	echo("TOTAL ROWS: \n");
	checkSuccess(sqlrcur_totalRows($cur),8);
	echo("\n");

	echo("FIRST ROW INDEX: \n");
	checkSuccess(sqlrcur_firstRowIndex($cur),0);
	echo("\n");

	echo("END OF RESULT SET: \n");
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	echo("\n");

	echo("FIELDS BY INDEX: \n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"1");
	checkSuccess(sqlrcur_getField($cur,0,2),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,3),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,4),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,5),"testchar1                               ");
	checkSuccess(sqlrcur_getField($cur,0,6),"testvarchar1");
	checkSuccess(sqlrcur_getField($cur,0,7)," 1-Jan-2001");
	checkSuccess(sqlrcur_getField($cur,0,8),"01:00:00");
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,7,1),"8");
	checkSuccess(sqlrcur_getField($cur,7,2),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,3),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,4),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,5),"testchar8                               ");
	checkSuccess(sqlrcur_getField($cur,7,6),"testvarchar8");
	checkSuccess(sqlrcur_getField($cur,7,7)," 1-Jan-2008");
	checkSuccess(sqlrcur_getField($cur,7,8),"08:00:00");
	echo("\n");

	echo("FIELD LENGTHS BY INDEX: \n");
	checkSuccess(sqlrcur_getFieldLength($cur,0,0),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,1),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,2),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,3),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,4),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,5),40);
	checkSuccess(sqlrcur_getFieldLength($cur,0,6),12);
	checkSuccess(sqlrcur_getFieldLength($cur,0,7),11);
	checkSuccess(sqlrcur_getFieldLength($cur,0,8),8);
	echo("\n");
	checkSuccess(sqlrcur_getFieldLength($cur,7,0),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,1),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,2),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,3),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,4),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,5),40);
	checkSuccess(sqlrcur_getFieldLength($cur,7,6),12);
	checkSuccess(sqlrcur_getFieldLength($cur,7,7),11);
	checkSuccess(sqlrcur_getFieldLength($cur,7,8),8);
	echo("\n");

	echo("FIELDS BY NAME: \n");
	checkSuccess(sqlrcur_getField($cur,0,"testint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testsmallint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testfloat"),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,"testdouble"),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,"testdecimal"),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,"testchar"),"testchar1                               ");
	checkSuccess(sqlrcur_getField($cur,0,"testvarchar"),"testvarchar1");
	checkSuccess(sqlrcur_getField($cur,0,"testdate")," 1-Jan-2001");
	checkSuccess(sqlrcur_getField($cur,0,"testtime"),"01:00:00");
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,7,"testint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testsmallint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testfloat"),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,"testdouble"),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,"testdecimal"),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,"testchar"),"testchar8                               ");
	checkSuccess(sqlrcur_getField($cur,7,"testvarchar"),"testvarchar8");
	checkSuccess(sqlrcur_getField($cur,7,"testdate")," 1-Jan-2008");
	checkSuccess(sqlrcur_getField($cur,7,"testtime"),"08:00:00");
	echo("\n");

	echo("FIELD LENGTHS BY NAME: \n");
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testsmallint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testfloat"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testdouble"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testdecimal"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testchar"),40);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testvarchar"),12);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testdate"),11);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testtime"),8);
	echo("\n");
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testsmallint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testfloat"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testdouble"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testdecimal"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testchar"),40);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testvarchar"),12);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testdate"),11);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testtime"),8);
	echo("\n");

	echo("FIELDS BY ARRAY: \n");
	$fields=sqlrcur_getRow($cur,0);
	checkSuccess($fields[0],"1");
	checkSuccess($fields[1],"1");
	checkSuccess($fields[2],"1.1");
	checkSuccess($fields[3],"1.1");
	checkSuccess($fields[4],"1.1");
	checkSuccess($fields[5],"testchar1                               ");
	checkSuccess($fields[6],"testvarchar1");
	checkSuccess($fields[7]," 1-Jan-2001");
	checkSuccess($fields[8],"01:00:00");
	echo("\n");

	echo("FIELD LENGTHS BY ARRAY: \n");
	$fieldlens=sqlrcur_getRowLengths($cur,0);
	checkSuccess($fieldlens[0],1);
	checkSuccess($fieldlens[1],1);
	checkSuccess($fieldlens[2],3);
	checkSuccess($fieldlens[3],3);
	checkSuccess($fieldlens[4],3);
	checkSuccess($fieldlens[5],40);
	checkSuccess($fieldlens[6],12);
	checkSuccess($fieldlens[7],11);
	checkSuccess($fieldlens[8],8);
	echo("\n");

	echo("FIELDS BY ASSOCIATIVE ARRAY: \n");
	$fields=sqlrcur_getRowAssoc($cur,0);
	checkSuccess($fields["testint"],"1");
	checkSuccess($fields["testsmallint"],"1");
	checkSuccess($fields["testfloat"],"1.1");
	checkSuccess($fields["testdouble"],"1.1");
	checkSuccess($fields["testdecimal"],"1.1");
	checkSuccess($fields["testchar"],"testchar1                               ");
	checkSuccess($fields["testvarchar"],"testvarchar1");
	checkSuccess($fields["testdate"]," 1-Jan-2001");
	checkSuccess($fields["testtime"],"01:00:00");
	echo("\n");
	$fields=sqlrcur_getRowAssoc($cur,7);
	checkSuccess($fields["testint"],"8");
	checkSuccess($fields["testsmallint"],"8");
	checkSuccess($fields["testfloat"],"8.1");
	checkSuccess($fields["testdouble"],"8.1");
	checkSuccess($fields["testdecimal"],"8.1");
	checkSuccess($fields["testchar"],"testchar8                               ");
	checkSuccess($fields["testvarchar"],"testvarchar8");
	checkSuccess($fields["testdate"]," 1-Jan-2008");
	checkSuccess($fields["testtime"],"08:00:00");
	echo("\n");

	echo("FIELD LENGTHS BY ASSOCIATIVE ARRAY: \n");
	$fieldlengths=sqlrcur_getRowLengthsAssoc($cur,0);
	checkSuccess($fieldlengths["testint"],1);
	checkSuccess($fieldlengths["testsmallint"],1);
	checkSuccess($fieldlengths["testfloat"],3);
	checkSuccess($fieldlengths["testdouble"],3);
	checkSuccess($fieldlengths["testdecimal"],3);
	checkSuccess($fieldlengths["testchar"],40);
	checkSuccess($fieldlengths["testvarchar"],12);
	checkSuccess($fieldlengths["testdate"],11);
	checkSuccess($fieldlengths["testtime"],8);
	echo("\n");
	$fieldlengths=sqlrcur_getRowLengthsAssoc($cur,7);
	checkSuccess($fieldlengths["testint"],1);
	checkSuccess($fieldlengths["testsmallint"],1);
	checkSuccess($fieldlengths["testfloat"],3);
	checkSuccess($fieldlengths["testdouble"],3);
	checkSuccess($fieldlengths["testdecimal"],3);
	checkSuccess($fieldlengths["testchar"],40);
	checkSuccess($fieldlengths["testvarchar"],12);
	checkSuccess($fieldlengths["testdate"],11);
	checkSuccess($fieldlengths["testtime"],8);
	echo("\n");

	echo("INDIVIDUAL SUBSTITUTIONS: \n");
	sqlrcur_sendQuery($cur,"drop table testtable1");
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable1 (col1 int, col2 varchar(40), col3 real)"),1);
	sqlrcur_prepareQuery($cur,"insert into testtable1 (col1, col2, col3) values ($(var1),'$(var2)',$(var3))");
	sqlrcur_substitution($cur,"var1",1);
	sqlrcur_substitution($cur,"var2","hello");
	sqlrcur_substitution($cur,"var3",10.5556,6,4);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("FIELDS: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable1"),1);
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"hello");
	checkSuccess(sqlrcur_getField($cur,0,2),"10.5556");
	checkSuccess(sqlrcur_sendQuery($cur,"delete from testtable1"),1);
	echo("\n");

	echo("ARRAY SUBSTITUTIONS: \n");
	sqlrcur_prepareQuery($cur,"insert into testtable1 (col1, col2, col3) values ($(var1),'$(var2)',$(var3))");
	$vars=array("var1","var2","var3");
	$vals=array(1,"hello",10.5556);
	$precs=array(0,0,6);
	$scales=array(0,0,4);
	sqlrcur_substitutions($cur,$vars,$vals,$precs,$scales);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("FIELDS: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable1"),1);
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"hello");
	checkSuccess(sqlrcur_getField($cur,0,2),"10.5556");
	checkSuccess(sqlrcur_sendQuery($cur,"delete from testtable1"),1);
	echo("\n");


	echo("NULLS as Nulls: \n");
	sqlrcur_sendQuery($cur,"drop table testtable1");
	sqlrcur_sendQuery($cur,"create table testtable1 (col1 char(1), col2 char(1), col3 char(1))");
	sqlrcur_getNullsAsNulls($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable1 (col1, col2, col3) values ('1',NULL,NULL)"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable1"),1);
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),NULL);
	checkSuccess(sqlrcur_getField($cur,0,2),NULL);
	sqlrcur_getNullsAsEmptyStrings($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable1"),1);
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"");
	checkSuccess(sqlrcur_getField($cur,0,2),"");
	checkSuccess(sqlrcur_sendQuery($cur,"drop table testtable1"),1);
	sqlrcur_getNullsAsNulls($cur);
	echo("\n");

	echo("RESULT SET BUFFER SIZE: \n");
	checkSuccess(sqlrcur_getResultSetBufferSize($cur),0);
	sqlrcur_setResultSetBufferSize($cur,2);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getResultSetBufferSize($cur),2);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),0);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),2);
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),2);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),4);
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),6);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),8);
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),8);
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	checkSuccess(sqlrcur_rowCount($cur),8);
	echo("\n");

	echo("DONT GET COLUMN INFO: \n");
	sqlrcur_dontGetColumnInfo($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getColumnName($cur,0),NULL);
	checkSuccess(sqlrcur_getColumnLength($cur,0),0);
	checkSuccess(sqlrcur_getColumnType($cur,0),NULL);
	sqlrcur_getColumnInfo($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getColumnName($cur,0),"testsmallint");
	checkSuccess(sqlrcur_getColumnLength($cur,0),2);
	checkSuccess(sqlrcur_getColumnType($cur,0),"SMALLINT");
	echo("\n");

	echo("SUSPENDED SESSION: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	checkSuccess(sqlrcur_getField($cur,3,0),"4");
	checkSuccess(sqlrcur_getField($cur,4,0),"5");
	checkSuccess(sqlrcur_getField($cur,5,0),"6");
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	checkSuccess(sqlrcur_getField($cur,3,0),"4");
	checkSuccess(sqlrcur_getField($cur,4,0),"5");
	checkSuccess(sqlrcur_getField($cur,5,0),"6");
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	checkSuccess(sqlrcur_getField($cur,3,0),"4");
	checkSuccess(sqlrcur_getField($cur,4,0),"5");
	checkSuccess(sqlrcur_getField($cur,5,0),"6");
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");

	echo("SUSPENDED RESULT SET: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	$id=sqlrcur_getResultSetId($cur);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	checkSuccess(sqlrcur_resumeResultSet($cur,$id),1);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),4);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),6);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),6);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),8);
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),8);
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	checkSuccess(sqlrcur_rowCount($cur),8);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("CACHED RESULT SET: \n");
	sqlrcur_cacheToFile($cur,"/tmp/cachefile1");
	sqlrcur_setCacheTtl($cur,200);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	$filename=sqlrcur_getCacheFileName($cur);
	checkSuccess($filename,"/tmp/cachefile1");
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,$filename),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");

	echo("COLUMN COUNT FOR CACHED RESULT SET: \n");
	checkSuccess(sqlrcur_colCount($cur),10);
	echo("\n");

	echo("COLUMN NAMES FOR CACHED RESULT SET: \n");
	checkSuccess(sqlrcur_getColumnName($cur,0),"testsmallint");
	checkSuccess(sqlrcur_getColumnName($cur,1),"testint");
	checkSuccess(sqlrcur_getColumnName($cur,2),"testfloat");
	checkSuccess(sqlrcur_getColumnName($cur,3),"testdouble");
	checkSuccess(sqlrcur_getColumnName($cur,4),"testdecimal");
	checkSuccess(sqlrcur_getColumnName($cur,5),"testchar");
	checkSuccess(sqlrcur_getColumnName($cur,6),"testvarchar");
	checkSuccess(sqlrcur_getColumnName($cur,7),"testdate");
	checkSuccess(sqlrcur_getColumnName($cur,8),"testtime");
	checkSuccess(sqlrcur_getColumnName($cur,9),"testtimestamp");
	$cols=sqlrcur_getColumnNames($cur);
	checkSuccess($cols[0],"testsmallint");
	checkSuccess($cols[1],"testint");
	checkSuccess($cols[2],"testfloat");
	checkSuccess($cols[3],"testdouble");
	checkSuccess($cols[4],"testdecimal");
	checkSuccess($cols[5],"testchar");
	checkSuccess($cols[6],"testvarchar");
	checkSuccess($cols[7],"testdate");
	checkSuccess($cols[8],"testtime");
	checkSuccess($cols[9],"testtimestamp");
	echo("\n");

	echo("CACHED RESULT SET WITH RESULT SET BUFFER SIZE: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	sqlrcur_cacheToFile($cur,"/tmp/cachefile1");
	sqlrcur_setCacheTtl($cur,200);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	$filename=sqlrcur_getCacheFileName($cur);
	checkSuccess($filename,"/tmp/cachefile1");
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,$filename),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("FROM ONE CACHE FILE TO ANOTHER: \n");
	sqlrcur_cacheToFile($cur,"/tmp/cachefile2");
	checkSuccess(sqlrcur_openCachedResultSet($cur,"/tmp/cachefile1"),1);
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,"/tmp/cachefile2"),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");

	echo("FROM ONE CACHE FILE TO ANOTHER WITH RESULT SET BUFFER SIZE: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	sqlrcur_cacheToFile($cur,"/tmp/cachefile2");
	checkSuccess(sqlrcur_openCachedResultSet($cur,"/tmp/cachefile1"),1);
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,"/tmp/cachefile2"),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("CACHED RESULT SET WITH SUSPEND AND RESULT SET BUFFER SIZE: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	sqlrcur_cacheToFile($cur,"/tmp/cachefile1");
	sqlrcur_setCacheTtl($cur,200);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	$filename=sqlrcur_getCacheFileName($cur);
	checkSuccess($filename,"/tmp/cachefile1");
	$id=sqlrcur_getResultSetId($cur);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	echo("\n");
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	checkSuccess(sqlrcur_resumeCachedResultSet($cur,$id,$filename),1);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),4);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),6);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),6);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),8);
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),8);
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	checkSuccess(sqlrcur_rowCount($cur),8);
	sqlrcur_cacheOff($cur);
	echo("\n");
	checkSuccess(sqlrcur_openCachedResultSet($cur,$filename),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("COMMIT AND ROLLBACK: \n");
	$secondcon=sqlrcon_alloc($host,$port, 
					$socket,$user,$password,0,1);
	$secondcur=sqlrcur_alloc($secondcon);
	checkSuccess(sqlrcur_sendQuery($secondcur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getField($secondcur,0,0),"1");
	checkSuccess(sqlrcon_commit($con),1);
	checkSuccess(sqlrcur_sendQuery($secondcur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getField($secondcur,0,0),"1");
	checkSuccess(sqlrcon_autoCommitOn($con),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable (testsmallint, testint, testfloat, testdouble, testdecimal, testchar, testvarchar, testdate, testtime) values (10,10,10.1,10.1,10.1,'testchar10','testvarchar10','20100101','100000')"),1);
	checkSuccess(sqlrcur_sendQuery($secondcur,"select * from testtable"),1);
	checkSuccess(sqlrcur_getField($secondcur,8,0),"10");
	checkSuccess(sqlrcon_autoCommitOff($con),1);
	echo("\n");

	# drop existing table
	sqlrcur_sendQuery($cur,"drop table testtable");

	# invalid queries...
	echo("INVALID QUERIES: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable"),0);
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	echo("\n");
?></pre></html>
