<?php /* SRG Default PHP Header - 1.3.3 
	   * 
	   * If you make modifications to this file you *must* remove the
	   * 'SRG Default PHP Header - 1.3.3' string on the first line or your
	   * changes may be overwritten.
	   *
	   * $Id: header.php,v 1.4 2005/03/08 07:21:22 mattgbrown Exp $
	   *
	   */
/* Define some defaults */
define("CONFIG_FILE", "/etc/srg/srg.conf");
define("DEFAULT_OUTPUTURL", "/srg_reports");
define("DEFAULT_TITLE", "SRG - Squid Log Analysis");

/* Read configuration information from the default configuration file */
$outputurl = DEFAULT_OUTPUTURL;
$title = DEFAULT_TITLE;

$config = @file(CONFIG_FILE);

if ($config) {
        /* Loop through lines and find output URL or title*/
        for ($i=0; $i<count($config); $i++) {
                if (substr($config[$i], 0, 5) == "title") {
                        $title = substr($config[i], 7);
                        $title = trim(trim($title), "\"");
                        continue;
                }
                if (substr($config[$i], 0, 10) == "output_url") {
                        $outputurl = substr($config[$i], 12);
                        $outputurl = trim(trim($outputurl), "\"");
                        continue;
                }
        }
}

/* Do any custom page setup below here */

/* if you have php_authentication (-A) enabled then this function must be 
 * filled in. 
 *
 * For each group in the report the name of the group is passed to this
 * function which must return true if the currently logged in user can view the
 * reports for the specified group.
 *
 * A return value of false causes the reports for the specified group not to be
 * displayed.
 */
function can_view($groupname) {
	/* Retrieve the currently logged in user from your session/cookie here */

	/* Check authentication here */

	/* But by default we'll have no authentication :) */
	return true;
}

/* This function is called when an error must be displayed to the user due to 
 * an access denied error or similar.
 */
function report_error($errormessage) {
	echo "<br><b>$errormessage</b><br>";	
}

/* Setup the page HTML here */
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta name="generator" value="SRG 1.3.3 (http://www.crc.net.nz/software/srg.php)">
<meta name="robots" content="noindex,nofollow">
<?php
	echo "<link href=\"$outputurl/style.css\" type=\"text/css\" " .
		"rel=\"stylesheet\">\n";
	echo "<title>$title</title>\n";
?>
</head>
<body>
<br>
<div align="center"><h1><?php echo $title; ?></h1></div>
<br>
