/* @(#)nixread.c	1.12 04/08/08 Copyright 1986, 1996-2003 J. Schilling */
/*
 *	Non interruptable extended read
 *
 *	Copyright (c) 1986, 1996-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include "schilyio.h"
#include <errno.h>

EXPORT int
_nixread(f, buf, count)
	int	f;
	void	*buf;
	int	count;
{
	register char *p = (char *)buf;
	register int ret;
	register int total = 0;
		int	oerrno = geterrno();

	while (count > 0) {
		while ((ret = read(f, p, count)) < 0) {
			if (geterrno() == EINTR) {
				/*
				 * Set back old 'errno' so we don't change the
				 * errno visible to the outside if we did
				 * not fail.
				 */
				seterrno(oerrno);
				continue;
			}
			return (ret);	/* Any other error */
		}
		if (ret == 0)		/* Something went wrong */
			break;

		total += ret;
		count -= ret;
		p += ret;
	}
	return (total);
}
