/*
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 */
#ifndef __SWAMIUI_GENVIEW_H__
#define __SWAMIUI_GENVIEW_H__

#include <gtk/gtk.h>
#include <instpatch.h>

#include "swamidll.h"

typedef struct _SwamiUIGenView SwamiUIGenView;
typedef struct _SwamiUIGenViewClass SwamiUIGenViewClass;

#define SWAMIUI_TYPE_GENVIEW   (swamiui_genview_get_type ())
#define SWAMIUI_GENVIEW(obj) \
  (GTK_CHECK_CAST ((obj), SWAMIUI_TYPE_GENVIEW, SwamiUIGenView))
#define SWAMIUI_GENVIEW_CLASS(klass) \
  (GTK_CHECK_CLASS_CAST ((klass), SWAMIUI_TYPE_GENVIEW, SwamiUIGenViewClass))
#define SWAMIUI_IS_GENVIEW(obj) \
  (GTK_CHECK_TYPE ((obj), SWAMIUI_TYPE_GENVIEW))
#define SWAMIUI_IS_GENVIEW_CLASS(klass) \
  (GTK_CHECK_CLASS_TYPE ((klass), SWAMIUI_TYPE_GENVIEW))

struct _SwamiUIGenView
{
  GtkScrolledWindow parent;

  IPZone *zone;			/* SoundFont item to sync to */
  GtkWidget *clists[6];		/* array of pointers to clist widgets */
  gboolean queue_update;	/* queue sync of view to zone */
};

struct _SwamiUIGenViewClass
{
  GtkScrolledWindowClass parent_class;
};

SWAMI_API guint swamiui_genview_get_type (void);
SWAMI_API GtkWidget *swamiui_genview_new (void);
SWAMI_API void swamiui_genview_set_item (SwamiUIGenView *genview,
					 IPItem *item);
SWAMI_API void swamiui_genview_update (SwamiUIGenView *genview);
SWAMI_API int swamiui_genview_get_genids (guint8 **genids);

#endif
