/*
 * multi_filesel.c - Multi file selection dialog widget
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include "multi_filesel.h"
#include "i18n.h"

static void multi_filesel_init (MultiFileSel *multisel);

guint
multi_filesel_get_type (void)
{
  static guint multi_filesel_type = 0;

  if (!multi_filesel_type)
    {
      GtkTypeInfo multi_filesel_info = {
	"MultiFileSel",
	sizeof (MultiFileSel),
	sizeof (MultiFileSelClass),
	(GtkClassInitFunc) NULL,
	(GtkObjectInitFunc) multi_filesel_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };
      multi_filesel_type =
	gtk_type_unique (gtk_file_selection_get_type (), &multi_filesel_info);
    }

  return multi_filesel_type;
}

static void
multi_filesel_init (MultiFileSel *multisel)
{
  GtkWidget *lbl;
  GList *p;

  /* to allow multiple file selection */
  gtk_clist_set_selection_mode (GTK_CLIST (GTK_FILE_SELECTION (multisel)->
					   file_list), GTK_SELECTION_EXTENDED);

  multisel->button_box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (multisel->button_box);
  gtk_box_pack_start (GTK_BOX (GTK_FILE_SELECTION (multisel)->main_vbox),
		      multisel->button_box, FALSE, FALSE, 0);

  multisel->add_button = gtk_button_new_with_label (_("Add selected files"));
  gtk_widget_show (multisel->add_button);
  gtk_box_pack_start (GTK_BOX (multisel->button_box), multisel->add_button,
		      FALSE, FALSE, 0);

  /* change the Cancel button to Close */
  p = gtk_container_children (GTK_CONTAINER (GTK_FILE_SELECTION (multisel)
					     ->cancel_button));
  gtk_container_remove (GTK_CONTAINER (GTK_FILE_SELECTION
				       (multisel)->cancel_button),
			GTK_WIDGET (p->data));
  g_list_free (p);

  lbl = gtk_label_new (_("Close"));
  gtk_container_add (GTK_CONTAINER (GTK_FILE_SELECTION (multisel)->
				    cancel_button), lbl);
  gtk_widget_show (lbl);
}

GtkWidget *
multi_filesel_new (const char *title)
{
  MultiFileSel *multisel;

  multisel = gtk_type_new (multi_filesel_get_type ());

  if (title) gtk_window_set_title (GTK_WINDOW (multisel), title);

  return GTK_WIDGET (multisel);
}

/**
 * Get current directory of multi file selection widget
 * @multisel Multi file selection dialog
 * Returns: Current directory of multi file selection dialog which should be
 *   freed when finished with.
 */
char *
multi_filesel_get_path (MultiFileSel *multisel)
{
  char *s;

  s = gtk_file_selection_get_filename (GTK_FILE_SELECTION (multisel));
  s = g_dirname (s);

  return (s);
}

/**
 * Get current list of selected files
 * @multisel Multi file selection object to get selection from
 * Returns: List of currently selected file name strings.
 */
GList *
multi_filesel_get_selected_files (MultiFileSel *multisel)
{
  GtkCList *clist;
  GList *p, *newlist = NULL;
  gchar *s;

  clist = GTK_CLIST (GTK_FILE_SELECTION (multisel)->file_list);

  p = clist->selection;
  while (p)
    {
      if (gtk_clist_get_text (clist, (gint)(p->data), 0, &s))
	newlist = g_list_append (newlist, s);

      p = g_list_next (p);
    }

  return (newlist);
}
