/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import java.util.Iterator;
import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispCompiler;
import org.jatha.compile.LispPrimitive;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

public class LessThanOrEqualPrimitive
extends LispPrimitive {
    public LessThanOrEqualPrimitive(Jatha lisp) {
        super(lisp, "<=", 2L, Long.MAX_VALUE);
    }

    public void Execute(SECDMachine machine) {
        LispValue args = machine.S.pop();
        if (args == this.f_lisp.NIL) {
            machine.S.push(this.f_lisp.T);
        } else {
            LispValue prevArg = args.first();
            args = args.cdr();
            Iterator iterator = args.iterator();
            while (iterator.hasNext()) {
                LispValue arg = (LispValue)iterator.next();
                if (prevArg.lessThanOrEqual(arg) == this.f_lisp.NIL) {
                    machine.S.push(this.f_lisp.NIL);
                    machine.C.pop();
                    return;
                }
                prevArg = arg;
            }
            machine.S.push(this.f_lisp.T);
        }
        machine.C.pop();
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) throws CompilerException {
        return compiler.compileArgsLeftToRight(args, valueList, this.f_lisp.makeCons(machine.LIS, this.f_lisp.makeCons(args.length(), code)));
    }
}

