/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.StatWindowPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class StatWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private ParaProfTrial trial = null;
    private DataSorter dataSorter;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private boolean userEventWindow;
    private JMenu optionsMenu = null;
    private JMenu windowsMenu = null;
    private JMenu unitsSubMenu = null;
    private JCheckBoxMenuItem sortByName = null;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JScrollPane sp = null;
    private StatWindowPanel panel = null;
    Vector list = null;
    private boolean name = false;
    private int order = 0;
    private int valueType = 2;
    private int units = 0;

    public StatWindow(ParaProfTrial paraProfTrial, int n, int n2, int n3, DataSorter dataSorter, boolean bl) {
        this.trial = paraProfTrial;
        this.dataSorter = dataSorter;
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.userEventWindow = bl;
        this.setLocation(new Point(0, 0));
        this.setSize(new Dimension(1000, 600));
        if (n == -1 && bl) {
            throw new RuntimeException("There is no User Event data for mean");
        }
        if (n == -1) {
            this.setTitle("Mean Data Statistics: " + paraProfTrial.getTrialIdentifier(true));
        } else {
            if (bl) {
                this.valueType = 12;
            }
            this.setTitle("n,c,t, " + n + "," + n2 + "," + n3 + " - " + paraProfTrial.getTrialIdentifier(true));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StatWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        this.optionsMenu = new JMenu("Options");
        Object var11_11 = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.sortByName = new JCheckBoxMenuItem("Sort By Name", false);
        this.sortByName.addActionListener(this);
        this.optionsMenu.add(this.sortByName);
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        this.unitsSubMenu = new JMenu("Select Units");
        if (!bl) {
            buttonGroup = new ButtonGroup();
            jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            this.unitsSubMenu.add(jRadioButtonMenuItem);
        }
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Sort By");
        buttonGroup = new ButtonGroup();
        if (bl) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Userevents", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Min. Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Max. Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Mean Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        } else {
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Subroutines", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Per Call Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        this.showPathTitleInReverse = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
        this.showPathTitleInReverse.addActionListener(this);
        this.optionsMenu.add(this.showPathTitleInReverse);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.addMenuListener(this);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenu3.addMenuListener(this);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(this.windowsMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new StatWindowPanel(paraProfTrial, n, n2, n3, this, bl);
        this.sp = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setHeader();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        ParaProf.incrementNumWindows();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                } else if (string.equals("Preferences...")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Sort By Name")) {
                    this.name = this.sortByName.isSelected();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Descending Order")) {
                    this.order = this.descendingOrder.isSelected() ? 0 : 1;
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Exclusive")) {
                    this.valueType = 2;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Inclusive")) {
                    this.valueType = 4;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Calls")) {
                    this.valueType = 6;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Subroutines")) {
                    this.valueType = 8;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Per Call Value")) {
                    this.valueType = 10;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Userevents")) {
                    this.valueType = 12;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Min. Value")) {
                    this.valueType = 14;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Max. Value")) {
                    this.valueType = 16;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Mean Value")) {
                    this.valueType = 18;
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Microseconds")) {
                    this.units = 0;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Milliseconds")) {
                    this.units = 1;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Seconds")) {
                    this.units = 2;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("hr:min:sec")) {
                    this.units = 3;
                    this.setHeader();
                    this.panel.repaint();
                } else if (string.equals("Show Path Title in Reverse")) {
                    if (this.nodeID == -1) {
                        this.setTitle("Mean Data Window Total: " + this.trial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    } else {
                        this.setTitle("Total n,c,t, " + this.nodeID + "," + this.contextID + "," + this.threadID + " - " + this.trial.getTrialIdentifier(this.showPathTitleInReverse.isSelected()));
                    }
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                } else if (string.equals("Show ParaProf Manager")) {
                    new ParaProfManagerWindow().show();
                } else if (string.equals("Show Function Ledger")) {
                    new LedgerWindow(this.trial, 0).show();
                } else if (string.equals("Show Group Ledger")) {
                    new LedgerWindow(this.trial, 1).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new LedgerWindow(this.trial, 2).show();
                } else if (string.equals("Show Call Path Relations")) {
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, this.getDataSorter(), 2);
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.isTimeMetric() && !this.userEventWindow) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        }
        if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            if (!this.trial.isTimeMetric()) {
                this.units = 0;
            }
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the statistics window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you textual statistics.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click on any line within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default color");
        ParaProf.helpWindow.writeText(", or to show more details about the Function / User Event.");
        ParaProf.helpWindow.writeText("You can also left click any line to highlight it in the system.");
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        this.list = this.name ? (this.userEventWindow ? this.dataSorter.getUserEventProfiles(this.nodeID, this.contextID, this.threadID, this.order) : this.dataSorter.getFunctionProfiles(this.nodeID, this.contextID, this.threadID, this.order)) : (this.userEventWindow ? this.dataSorter.getUserEventProfiles(this.nodeID, this.contextID, this.threadID, this.valueType + this.order) : this.dataSorter.getFunctionProfiles(this.nodeID, this.contextID, this.threadID, this.valueType + this.order));
    }

    public Vector getData() {
        return this.list;
    }

    public int getValueType() {
        return this.valueType;
    }

    public int units() {
        return this.units;
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            Preferences preferences = this.trial.getPreferences();
            jTextArea.setFont(new Font(preferences.getParaProfFont(), preferences.getFontStyle(), preferences.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.userEventWindow) {
            return "Sorted By: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n";
        }
        return "Metric Name: " + this.trial.getMetricName(this.trial.getSelectedMetricID()) + "\n" + "Sorted By: " + UtilFncs.getValueTypeString((int)this.valueType) + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.trial.isTimeMetric(), (boolean)this.trial.isDerivedMetric()) + "\n";
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            this.setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }
}

