/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.CharDataChunk;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

abstract class AbstractCharReader
extends XMLEntityReader {
    protected CharDataChunk fCurrentChunk = null;
    protected int fCurrentIndex = 0;
    protected char[] fMostRecentData = null;
    protected int fMostRecentChar = 0;
    protected int fLength = 0;
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private StringPool fStringPool = null;
    private boolean fCalledCharPropInit = false;
    private boolean fCallClearPreviousChunk = true;
    private Vector fDeferredErrors = null;

    protected AbstractCharReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, StringPool stringPool) {
        super(xMLEntityHandler, xMLErrorReporter, bl);
        this.fStringPool = stringPool;
        this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, null);
    }

    protected abstract int fillCurrentChunk() throws Exception;

    protected void deferException(int n, Object[] objectArray, int n2) {
        if (this.fDeferredErrors == null) {
            this.fDeferredErrors = new Vector();
        }
        DeferredError deferredError = new DeferredError(n, objectArray, n2);
        this.fDeferredErrors.addElement(deferredError);
    }

    protected XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader entityReader = super.changeReaders();
        this.fCurrentChunk.releaseChunk();
        this.fCurrentChunk = null;
        return entityReader;
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        this.fCurrentChunk.append(charBuffer, n, n2);
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    public boolean lookingAtChar(char c, boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n != c) {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtChar(c, bl);
            }
            return false;
        }
        if (bl) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            if (++this.fCurrentIndex == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            }
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 55296) {
            if (n >= 32 || n == 9) {
                if (bl) {
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                }
                return true;
            }
            if (n == 10) {
                if (bl) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    this.loadNextChar();
                }
                return true;
            }
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtValidChar(bl);
            }
            return false;
        }
        if (n > 65533) {
            return false;
        }
        if (n < 56320) {
            boolean bl2;
            CharDataChunk charDataChunk = this.fCurrentChunk;
            int n2 = this.fCurrentIndex;
            int n3 = this.fCurrentOffset;
            n = this.loadNextChar();
            boolean bl3 = bl2 = n >= 56320 && n < 57344;
            if (!bl2 || !bl) {
                this.fCurrentChunk = charDataChunk;
                this.fCurrentIndex = n2;
                this.fCurrentOffset = n3;
                this.fMostRecentData = charDataChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[n2] & 0xFFFF;
                return bl2;
            }
        } else if (n < 57344) {
            return false;
        }
        if (bl) {
            ++this.fCharacterCounter;
            this.loadNextChar();
        }
        return true;
    }

    public boolean lookingAtSpace(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            if (!bl) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (n == 10) {
            if (!bl) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtSpace(bl);
            }
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public void skipToChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (n != c) {
            if (n == 0) {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipToChar(c);
                    return;
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            n = this.loadNextChar();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int n = this.fMostRecentChar;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            n = this.loadNextChar();
        }
    }

    public void skipPastName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                return;
            }
        }
        while (true) {
            ++this.fCharacterCounter;
            n = this.loadNextChar();
            if (c == n) {
                return;
            }
            if (n < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n] & 4) == 0) break;
        }
    }

    public void skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (c != n) {
            if (n < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[n] & 4) == 0) {
                    return;
                }
            }
            ++this.fCharacterCounter;
            n = this.loadNextChar();
        }
        return;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = cArray.length;
        char[] cArray2 = this.fMostRecentData;
        int n2 = this.fCurrentIndex;
        if (n2 + n <= 16384) {
            int n3 = 0;
            while (n3 < n) {
                if (cArray2[n2++] != cArray[n3]) {
                    return false;
                }
                ++n3;
            }
            this.fCharacterCounter += n;
            this.fCurrentOffset += n;
            this.fCurrentIndex = n2;
            if (n2 == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = cArray2[n2] & 0xFFFF;
            }
            return true;
        }
        CharDataChunk charDataChunk = this.fCurrentChunk;
        int n4 = this.fCurrentOffset;
        int n5 = n2;
        int n6 = 0;
        while (n2 < 16384) {
            if (cArray2[n2++] == cArray[n6++]) continue;
            return false;
        }
        this.slowLoadNextChar();
        cArray2 = this.fMostRecentData;
        n2 = 0;
        while (n6 < n) {
            if (cArray2[n2++] == cArray[n6++]) continue;
            this.fCurrentChunk = charDataChunk;
            this.fCurrentIndex = n5;
            this.fCurrentOffset = n4;
            this.fMostRecentData = charDataChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[n5] & 0xFFFF;
            return false;
        }
        this.fCharacterCounter += n;
        this.fCurrentOffset += n;
        this.fCurrentIndex = n2;
        if (n2 == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = cArray2[n2] & 0xFFFF;
        }
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
        } else if (n == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanInvalidChar();
            }
            if (this.fDeferredErrors != null) {
                int n2 = 0;
                while (n2 < this.fDeferredErrors.size()) {
                    DeferredError deferredError = (DeferredError)this.fDeferredErrors.elementAt(n2);
                    if (deferredError.offset == this.fCurrentIndex) {
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", deferredError.errorCode, 0, deferredError.args, 2);
                        this.fDeferredErrors.removeElementAt(n2);
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return -1;
                    }
                    ++n2;
                }
            }
            ++this.fCharacterCounter;
            this.loadNextChar();
        } else {
            ++this.fCharacterCounter;
            if (n >= 55296 && n < 56320) {
                int n3 = this.loadNextChar();
                if (n3 >= 56320 && n3 < 57344) {
                    n = (n - 55296 << 10) + (n3 - 56320) + 65536;
                    this.loadNextChar();
                }
            } else {
                this.loadNextChar();
            }
        }
        return n;
    }

    public int scanCharRef(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanCharRef(bl);
            }
            return -2;
        }
        int n2 = 0;
        if (bl) {
            if (n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) {
                return -2;
            }
            n2 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
        } else {
            if (n < 48 || n > 57) {
                return -2;
            }
            n2 = n - 48;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        boolean bl2 = false;
        while ((n = this.fMostRecentChar) != 0 && !(bl ? n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0 : n < 48 || n > 57)) {
            int n3;
            ++this.fCharacterCounter;
            this.loadNextChar();
            if (bl) {
                n3 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
                n2 = (n2 << 4) + n3;
            } else {
                n3 = n - 48;
                n2 = n2 * 10 + n3;
            }
            if (n2 <= 0x10FFFF) continue;
            bl2 = true;
            n2 = 0;
        }
        if (n != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        if (bl2) {
            return -3;
        }
        return n2;
    }

    public int scanStringLiteral() throws Exception {
        boolean bl = this.lookingAtChar('\'', true);
        if (!bl && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int n = this.fCurrentOffset;
        char c = bl ? (char)'\'' : '\"';
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int n2 = this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanAttValue(char c, boolean bl) throws Exception {
        int n = this.fCurrentOffset;
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int n2 = bl ? this.addSymbol(n, this.fCurrentOffset - n) : this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanEntityValue(int n, boolean bl) throws Exception {
        int n2;
        block5: {
            n2 = this.fCurrentOffset;
            do {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders();
                    return -5;
                }
                if (n != -1 && this.lookingAtChar((char)n, false)) {
                    if (!bl) {
                        return -1;
                    }
                    break block5;
                }
                if (this.lookingAtChar('&', false)) {
                    return -2;
                }
                if (!this.lookingAtChar('%', false)) continue;
                return -3;
            } while (this.lookingAtValidChar(true));
            return -4;
        }
        int n3 = this.addString(n2, this.fCurrentOffset - n2);
        this.lookingAtChar((char)n, true);
        return n3;
    }

    public int scanName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0) {
                return -1;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                return -1;
            }
        }
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        char[] cArray = this.fMostRecentData;
        if (++n3 == 16384) {
            this.slowLoadNextChar();
            n3 = 0;
            cArray = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int n4 = 0;
        while (true) {
            n4 = StringHasher.hashChar(n4, n);
            n = cArray[n3] & 0xFFFF;
            if (c == n) break;
            if (n < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n] == 0) {
                    break;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[n] & 4) == 0) break;
            }
            if (++n3 == 16384) {
                this.slowLoadNextChar();
                n3 = 0;
                cArray = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = n3;
        this.fMostRecentChar = n;
        n4 = StringHasher.finishHash(n4);
        int n5 = this.fCurrentOffset - n2;
        int n6 = this.fCurrentChunk.addSymbol(n2, n5, n4);
        return n6;
    }

    public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws Exception {
        char[] cArray = charArrayRange.chars;
        int n = charArrayRange.offset;
        int n2 = charArrayRange.length;
        int n3 = this.fMostRecentChar;
        int n4 = 0;
        while (n4 < n2) {
            if (n3 != cArray[n++]) {
                this.skipPastNmtoken(c);
                return false;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            n3 = ++this.fCurrentIndex == 16384 ? this.slowLoadNextChar() : (this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF);
            ++n4;
        }
        if (n3 == c) {
            return true;
        }
        if (n3 < 128) {
            if (XMLCharacterProperties.fgAsciiNameChar[n3] == 0) {
                return true;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n3] & 4) == 0) {
                return true;
            }
        }
        this.skipPastNmtoken(c);
        return false;
    }

    public void scanQName(char c, QName qName) throws Exception {
        int n;
        int n2 = this.fMostRecentChar;
        if (n2 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n2] == 0) {
                qName.clear();
                return;
            }
            if (n2 == 58) {
                qName.clear();
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n2] & 2) == 0) {
                qName.clear();
                return;
            }
        }
        int n3 = this.fCurrentOffset;
        int n4 = this.fCurrentIndex;
        char[] cArray = this.fMostRecentData;
        if (++n4 == 16384) {
            this.slowLoadNextChar();
            n4 = 0;
            cArray = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int n5 = 0;
        int n6 = -1;
        while (true) {
            n5 = StringHasher.hashChar(n5, n2);
            n2 = cArray[n4] & 0xFFFF;
            if (c == n2) break;
            if (n2 < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n2] == 0) break;
                if (n2 == 58) {
                    if (n6 != -1) break;
                    n6 = this.fCurrentOffset;
                    if (n4 + 1 == 16384) {
                        CharDataChunk charDataChunk = this.fCurrentChunk;
                        int n7 = this.fCurrentOffset;
                        n2 = this.slowLoadNextChar();
                        this.fCurrentChunk = charDataChunk;
                        this.fCurrentOffset = n7;
                        this.fMostRecentData = charDataChunk.toCharArray();
                    } else {
                        n2 = cArray[n4 + 1] & 0xFFFF;
                    }
                    n = 1;
                    if (n2 < 128) {
                        if (XMLCharacterProperties.fgAsciiInitialNameChar[n2] == 0 || n2 == 58) {
                            n = 0;
                        }
                    } else {
                        if (!this.fCalledCharPropInit) {
                            XMLCharacterProperties.initCharFlags();
                            this.fCalledCharPropInit = true;
                        }
                        if ((XMLCharacterProperties.fgCharFlags[n2] & 2) == 0) {
                            n = 0;
                        }
                    }
                    n2 = 58;
                    if (n == 0) {
                        n6 = -1;
                        break;
                    }
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[n2] & 4) == 0) break;
            }
            if (++n4 == 16384) {
                this.slowLoadNextChar();
                n4 = 0;
                cArray = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = n4;
        this.fMostRecentChar = n2;
        n5 = StringHasher.finishHash(n5);
        n = this.fCurrentOffset - n3;
        qName.rawname = this.fCurrentChunk.addSymbol(n3, n, n5);
        qName.prefix = n6 == -1 ? -1 : this.addSymbol(n3, n6 - n3);
        qName.localpart = n6 == -1 ? qName.rawname : this.addSymbol(n6 + 1, this.fCurrentOffset - (n6 + 1));
        qName.uri = 0;
    }

    public int scanContent(QName qName) throws Exception {
        int n;
        int n2;
        if (this.fCallClearPreviousChunk && this.fCurrentChunk.clearPreviousChunk()) {
            this.fCallClearPreviousChunk = false;
        }
        int n3 = this.fCurrentOffset++;
        int n4 = this.fMostRecentChar;
        if (n4 < 128) {
            block0 : switch (XMLCharacterProperties.fgAsciiWSCharData[n4]) {
                case 0: {
                    ++this.fCharacterCounter;
                    n4 = this.loadNextChar();
                    break;
                }
                case 1: {
                    ++this.fCharacterCounter;
                    n4 = this.loadNextChar();
                    if (this.fInCDSect) break;
                    return this.recognizeMarkup(n4);
                }
                case 2: {
                    ++this.fCharacterCounter;
                    n4 = this.loadNextChar();
                    if (this.fInCDSect) break;
                    return this.recognizeReference(n4);
                }
                case 3: {
                    ++this.fCharacterCounter;
                    n4 = this.loadNextChar();
                    if (n4 != 93) break;
                    if (this.fCurrentIndex + 1 == 16384) {
                        CharDataChunk charDataChunk = this.fCurrentChunk;
                        int n5 = this.fCurrentIndex;
                        n2 = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = charDataChunk;
                            this.fCurrentIndex = n5;
                            this.fCurrentOffset = n2;
                            this.fMostRecentData = charDataChunk.toCharArray();
                            this.fMostRecentChar = 93;
                            break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') break;
                        ++this.fCurrentIndex;
                    }
                    this.loadNextChar();
                    this.fCharacterCounter += 2;
                    return 3;
                }
                case 4: {
                    if (n4 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                        this.changeReaders();
                        return 9;
                    }
                    return 9;
                }
                case 5: {
                    do {
                        if (n4 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            continue;
                        }
                        ++this.fCharacterCounter;
                    } while ((n4 = this.loadNextChar()) == 32 || n4 == 9 || n4 == 10);
                    if (n4 < 128) {
                        switch (XMLCharacterProperties.fgAsciiCharData[n4]) {
                            case 0: {
                                ++this.fCharacterCounter;
                                n4 = this.loadNextChar();
                                break block0;
                            }
                            case 1: {
                                if (!this.fInCDSect) {
                                    this.callCharDataHandler(n3, this.fCurrentOffset, true);
                                    ++this.fCharacterCounter;
                                    n4 = this.loadNextChar();
                                    return this.recognizeMarkup(n4);
                                }
                                ++this.fCharacterCounter;
                                n4 = this.loadNextChar();
                                break block0;
                            }
                            case 2: {
                                if (!this.fInCDSect) {
                                    this.callCharDataHandler(n3, this.fCurrentOffset, true);
                                    ++this.fCharacterCounter;
                                    n4 = this.loadNextChar();
                                    return this.recognizeReference(n4);
                                }
                                ++this.fCharacterCounter;
                                n4 = this.loadNextChar();
                                break block0;
                            }
                            case 3: {
                                int n6 = this.fCurrentOffset++;
                                n4 = this.loadNextChar();
                                if (n4 != 93) {
                                    ++this.fCharacterCounter;
                                    break block0;
                                }
                                if (this.fCurrentIndex + 1 == 16384) {
                                    CharDataChunk charDataChunk = this.fCurrentChunk;
                                    n2 = this.fCurrentIndex;
                                    n = this.fCurrentOffset;
                                    if (this.loadNextChar() != 62) {
                                        this.fCurrentChunk = charDataChunk;
                                        this.fCurrentIndex = n2;
                                        this.fCurrentOffset = n;
                                        this.fMostRecentData = charDataChunk.toCharArray();
                                        this.fMostRecentChar = 93;
                                        ++this.fCharacterCounter;
                                        break block0;
                                    }
                                } else {
                                    if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                        ++this.fCharacterCounter;
                                        break block0;
                                    }
                                    ++this.fCurrentIndex;
                                }
                                this.loadNextChar();
                                this.callCharDataHandler(n3, n6, true);
                                this.fCharacterCounter += 3;
                                return 3;
                            }
                            case 4: {
                                this.callCharDataHandler(n3, this.fCurrentOffset, true);
                                if (n4 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                                    this.changeReaders();
                                    return 9;
                                }
                                return 9;
                            }
                        }
                        break;
                    }
                    if (this.skipMultiByteCharData(n4)) break;
                    this.callCharDataHandler(n3, this.fCurrentOffset, true);
                    return 9;
                }
            }
        } else if (!this.skipMultiByteCharData(n4)) {
            return 9;
        }
        n4 = this.skipAsciiCharData();
        while (true) {
            if (n4 < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[n4]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        n4 = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(n3, this.fCurrentOffset, false);
                            ++this.fCharacterCounter;
                            n4 = this.loadNextChar();
                            return this.recognizeMarkup(n4);
                        }
                        ++this.fCharacterCounter;
                        n4 = this.loadNextChar();
                        break;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.callCharDataHandler(n3, this.fCurrentOffset, false);
                            ++this.fCharacterCounter;
                            n4 = this.loadNextChar();
                            return this.recognizeReference(n4);
                        }
                        ++this.fCharacterCounter;
                        n4 = this.loadNextChar();
                        break;
                    }
                    case 3: {
                        int n7 = this.fCurrentOffset++;
                        n4 = this.loadNextChar();
                        if (n4 != 93) {
                            ++this.fCharacterCounter;
                            break;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            CharDataChunk charDataChunk = this.fCurrentChunk;
                            n2 = this.fCurrentIndex;
                            n = this.fCurrentOffset;
                            if (this.loadNextChar() != 62) {
                                this.fCurrentChunk = charDataChunk;
                                this.fCurrentIndex = n2;
                                this.fCurrentOffset = n;
                                this.fMostRecentData = charDataChunk.toCharArray();
                                this.fMostRecentChar = 93;
                                ++this.fCharacterCounter;
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                ++this.fCharacterCounter;
                                break;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextChar();
                        this.callCharDataHandler(n3, n7, false);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    case 4: {
                        if (n4 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            n4 = this.loadNextChar();
                            break;
                        }
                        this.callCharDataHandler(n3, this.fCurrentOffset, false);
                        if (n4 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return 9;
                        }
                        return 9;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(n4)) {
                this.callCharDataHandler(n3, this.fCurrentOffset, false);
                return 9;
            }
            n4 = this.fMostRecentChar;
        }
    }

    private int recognizeMarkup(int n) throws Exception {
        switch (n) {
            case 0: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n == 0) {
                    --this.fCharacterCounter;
                    --this.fCurrentOffset;
                    return 11;
                }
                if (n == 45) {
                    ++this.fCharacterCounter;
                    n = this.loadNextChar();
                    if (n == 0) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (n != 45) break;
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                    return 1;
                }
                if (n != 91) break;
                int n2 = 0;
                while (n2 < 6) {
                    ++this.fCharacterCounter;
                    n = this.loadNextChar();
                    if (n == 0) {
                        this.fCharacterCounter -= 2 + n2;
                        this.fCurrentOffset -= 2 + n2;
                        return 11;
                    }
                    if (n != cdata_string[n2]) {
                        return 10;
                    }
                    ++n2;
                }
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 2;
            }
            case 47: {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference(int n) throws Exception {
        if (n == 0) {
            return 12;
        }
        if (n == 35) {
            ++this.fCharacterCounter;
            this.loadNextChar();
            return 7;
        }
        return 8;
    }

    private boolean skipMultiByteCharData(int n) throws Exception {
        if (n < 55296) {
            this.loadNextChar();
            return true;
        }
        if (n > 65533) {
            return false;
        }
        if (n >= 56320 && n < 57344) {
            return false;
        }
        if (n >= 55296 && n < 56320) {
            CharDataChunk charDataChunk = this.fCurrentChunk;
            int n2 = this.fCurrentIndex;
            int n3 = this.fCurrentOffset;
            n = this.loadNextChar();
            if (n < 56320 || n >= 57344) {
                this.fCurrentChunk = charDataChunk;
                this.fCurrentIndex = n2;
                this.fCurrentOffset = n3;
                this.fMostRecentData = charDataChunk.toCharArray();
                this.fMostRecentChar = this.fMostRecentData[n2] & 0xFFFF;
                return false;
            }
        }
        this.loadNextChar();
        return true;
    }

    private int skipAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        while (true) {
            char[] cArray = this.fMostRecentData;
            while (n < 16384) {
                int n3 = cArray[n] & 0xFFFF;
                if (n3 >= 128) {
                    this.fCurrentOffset = n2 + n;
                    this.fCurrentIndex = n;
                    this.fMostRecentChar = n3;
                    return n3;
                }
                if (XMLCharacterProperties.fgAsciiCharData[n3] == 0) {
                    ++this.fCharacterCounter;
                } else if (n3 == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    this.fCurrentOffset = n2 + n;
                    this.fCurrentIndex = n;
                    this.fMostRecentChar = n3;
                    return n3;
                }
                ++n;
            }
            n2 += n;
            this.slowLoadNextChar();
            n = 0;
        }
    }

    private void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = n2 - n;
        if (!this.fSendCharDataAsCharArray) {
            int n4 = this.addString(n, n3);
            if (bl) {
                this.fCharDataHandler.processWhitespace(n4);
            } else {
                this.fCharDataHandler.processCharacters(n4);
            }
            return;
        }
        CharDataChunk charDataChunk = this.fCurrentChunk.chunkFor(n);
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            if (n3 != 0) {
                if (bl) {
                    this.fCharDataHandler.processWhitespace(charDataChunk.toCharArray(), n5, n3);
                } else {
                    this.fCharDataHandler.processCharacters(charDataChunk.toCharArray(), n5, n3);
                }
            }
            return;
        }
        int n6 = n3;
        int n7 = 16384 - n5;
        if (bl) {
            this.fCharDataHandler.processWhitespace(charDataChunk.toCharArray(), n5, n7);
        } else {
            this.fCharDataHandler.processCharacters(charDataChunk.toCharArray(), n5, n7);
        }
        n6 -= n7;
        do {
            if ((charDataChunk = charDataChunk.nextChunk()) == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 14, 0, null));
            }
            int n8 = n7 = n6 <= 16384 ? n6 : 16384;
            if (bl) {
                this.fCharDataHandler.processWhitespace(charDataChunk.toCharArray(), 0, n7);
                continue;
            }
            this.fCharDataHandler.processCharacters(charDataChunk.toCharArray(), 0, n7);
        } while ((n6 -= n7) > 0);
    }

    private int slowLoadNextChar() throws Exception {
        this.fCallClearPreviousChunk = true;
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toCharArray();
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        this.fCurrentChunk = CharDataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    private int loadNextChar() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextChar();
        }
        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        return this.fMostRecentChar;
    }

    private boolean atEOF(int n) {
        return n > this.fLength;
    }

    private class DeferredError {
        int errorCode;
        Object[] args;
        int offset;

        DeferredError(int n, Object[] objectArray, int n2) {
            this.errorCode = n;
            this.args = objectArray;
            this.offset = n2;
        }
    }
}

