require 'tofu/tofulet'
require 'drb/drb'

def setup_bartender
  require 'yourapp'
  Tofu::Bartender.new(YourTofuSession)
end


def main
  DRb.start_service

  logger = WEBrick::Log::new($stderr, WEBrick::Log::DEBUG)

  s = WEBrick::HTTPServer.new(:Port => 2000,
                             :AddressFamily => Socket::AF_INET,
                             :BindAddress => '127.0.0.1',
                             :Logger => logger)

  bartender = setup_bartender
  logger.info "SumDiv: #{SumDiv.ancestors.inspect}"
  logger.info "BaseDiv: #{BaseDiv.ancestors.inspect}"
  s.mount("/div", WEBrick::Tofulet, bartender)

  trap("INT"){ s.shutdown }
  s.start
end

main
