# -*- Mode: ruby; indent-tabs-mode: nil -*-
#
#  $Id: tc_source_container.rb,v 1.1 2003/09/23 01:20:41 hisa Exp $
#
#  Copyright (c) 2003 FUJIMOTO Hisakuni <hisa@fobj.com>
#

require 'test/unit'
require 'tempura/source_container'
require 'tempura/source'
require 'tempura/charconv'

class TC_SourceContainer < Test::Unit::TestCase

  def test_s_new
    srcs = nil
    assert_nothing_raised { srcs = Tempura::SourceContainer.new }
    assert_nil( srcs[nil] )
    assert_nil( srcs[:ja] )
    assert_nil( srcs["ja"] )
  end

  def test_hash_set
    srcs = Tempura::SourceContainer.new
    assert_nothing_raised { srcs[nil] = Tempura::Source.new("view.en.html") }
    assert_nothing_raised { srcs[nil] = Tempura::Source.new("view.en.html", Tempura::CharConvDefault) }
    assert_nothing_raised { srcs[:ja] = Tempura::Source.new("view.ja.html", Tempura::CharConvEUC) }
  end

  def test_hash_get
    srcs = Tempura::SourceContainer.new
    src_default = Tempura::Source.new("view.en.html")
    src_en = Tempura::Source.new("view.en.html", Tempura::CharConvDefault)
    src_ja = Tempura::Source.new("view.ja.html", Tempura::CharConvEUC)
    srcs[nil] = src_default
    srcs[:en] = src_en
    srcs["ja"] = src_ja
    ret = nil
    assert_nothing_raised { ret = srcs[nil] }
    assert_equal( src_default, ret )
    assert_nothing_raised { ret = srcs[:en] }
    assert_equal( src_en, ret )
    assert_nothing_raised { ret = srcs["ja"] }
    assert_equal( src_ja, ret )
    assert_nothing_raised { ret = srcs[Time.now] }
    assert_equal( src_default, ret )
    assert_nothing_raised { ret = srcs[1234567] }
    assert_equal( src_default, ret )
  end

  def test_default
    srcs = Tempura::SourceContainer.new
    assert_nothing_raised { srcs.default }
    assert_nil( srcs.default )
    src_en = Tempura::Source.new("view.en.html", Tempura::CharConvDefault)
    src_ja = Tempura::Source.new("view.ja.html", Tempura::CharConvEUC)
    srcs[nil] = src_en
    assert_nothing_raised { srcs.default }
    assert_equal( src_en, srcs.default )
    srcs.default = src_ja
    assert_nothing_raised { srcs.default }
    assert_equal( src_ja, srcs.default )
  end

  def test_set_default
    srcs = Tempura::SourceContainer.new
    src_en = Tempura::Source.new("view.en.html", Tempura::CharConvDefault)
    src_ja = Tempura::Source.new("view.ja.html", Tempura::CharConvEUC)
    assert_nothing_raised { srcs.default = src_en }
    assert_equal( src_en, srcs.default )
    assert_equal( src_en, srcs[nil] )
    assert_nothing_raised { srcs.default = src_ja }
    assert_equal( src_ja, srcs.default )
    assert_equal( src_ja, srcs[nil] )
  end

  # ƥץ졼Ȥ򥻥åȤ롣
  def test_set
    srcs = Tempura::SourceContainer.new
    assert_nothing_raised { srcs.set(nil, "view.en.html") }
    assert_nothing_raised { srcs.set(nil, "view.en.html", Tempura::CharConvDefault) }
    assert_nothing_raised { srcs.set(:ja, "view.ja.html", Tempura::CharConvEUC) }
    assert_raises(Errno::ENOENT) { srcs.set(nil, "hoge.en") }
    assert_raises(Errno::ENOENT) { srcs.set(:ja,  "hoge.ja") }
  end

  # ƥץ졼Ȥʸ󤽤ΤΤǻꤹ
  def test_set_as_string
    view_en_html = File.open("view.en.html") { |f| f.read }
    view_ja_html = File.open("view.ja.html") { |f| f.read }
    srcs = Tempura::SourceContainer.new
    assert_nothing_raised { srcs.set_as_string(nil, view_en_html) }
    assert_nothing_raised { srcs.set_as_string(nil, view_en_html, Tempura::CharConvDefault) }
    assert_nothing_raised { srcs.set_as_string(:ja, view_ja_html, Tempura::CharConvEUC) }
  end

  def test_reload
    srcs = Tempura::SourceContainer.new
    srcs.set(nil, "view.en.html")
    srcs.set(:ja, "view.ja.html", Tempura::CharConvEUC)
    assert_nothing_raised { srcs.reload }
  end

end
