/* 
 * paper.h - a header for paper definition 
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#define LANDSCAPE_PAPER(p)    ((p)+100)
#define PAPER_ORIENTATION(p)  (((p)>=100)?1:0)
#define PAPER_BASIC_ID(p)     (((p)>=100)?((p)-100):(p))
#define PAPER_IS_PORTRAIT(p)  ((p)>=100)
#define PAPER_IS_LANDSCAPE(p) ((p)<100)

#define A1_PAPER           1
#define A2_PAPER           2
#define A3_PAPER           3
#define A4_PAPER           4
#define A5_PAPER           5
#define A6_PAPER           6
#define A7_PAPER           7
#define B1_PAPER          11
#define B2_PAPER          12
#define B3_PAPER          13
#define B4_PAPER          14
#define B5_PAPER          15
#define B6_PAPER          16
#define B7_PAPER          17
#define US_PAPER          21
#define LEGAL_PAPER       22
#define LETTER_PAPER      23
#define A1L_PAPER         (A1_PAPER+100)
#define A2L_PAPER         (A2_PAPER+100)
#define A3L_PAPER         (A3_PAPER+100)
#define A4L_PAPER         (A4_PAPER+100)
#define A5L_PAPER         (A5_PAPER+100)
#define A6L_PAPER         (A6_PAPER+100)
#define A7L_PAPER         (A7_PAPER+100)
#define B1L_PAPER         (B1_PAPER+100)
#define B2L_PAPER         (B2_PAPER+100)
#define B3L_PAPER         (B3_PAPER+100)
#define B4L_PAPER         (B4_PAPER+100)
#define B5L_PAPER         (B5_PAPER+100)
#define B6L_PAPER         (B6_PAPER+100)
#define B7L_PAPER         (B7_PAPER+100)
#define USL_PAPER         (US_PAPER+100)
#define LEGALL_PAPER      (LEGAL_PAPER+100)
#define LETTERL_PAPER     (LETTER_PAPER+100)

/* 
 * PAPER SIZE (in inch)
 */
#define A1_WIDTH       (59.4/2.54)
#define A1_HEIGHT      (84.0/2.54)
#define A2_WIDTH       (42.0/2.54)
#define A2_HEIGHT      (59.4/2.54)
#define A3_WIDTH       (29.7/2.54)
#define A3_HEIGHT      (42.0/2.54)
#define A4_WIDTH       (21.0/2.54)
#define A4_HEIGHT      (29.7/2.54)
#define A5_WIDTH       (14.85/2.54)
#define A5_HEIGHT      (21.0/2.54)
#define A6_WIDTH       (10.5/2.54)
#define A6_HEIGHT      (14.85/2.54)
#define A7_WIDTH       (7.42/2.54)
#define A7_HEIGHT      (10.5/2.54)
#define B1_WIDTH       (70.6/2.54)
#define B1_HEIGHT      (100.0/2.54)
#define B2_WIDTH       (50.0/2.54)
#define B2_HEIGHT      (70.6/2.54)
#define B3_WIDTH       (35.3/2.54)
#define B3_HEIGHT      (50.0/2.54)
#define B4_WIDTH       (25.0/2.54)
#define B4_HEIGHT      (35.3/2.54)
#define B5_WIDTH       (17.6/2.54)
#define B5_HEIGHT      (25.0/2.54)
#define B6_WIDTH       (13.5/2.54)
#define B6_HEIGHT      (17.6/2.54)
#define B7_WIDTH       (8.8/2.54)
#define B7_HEIGHT      (13.5/2.54)
#define LETTER_WIDTH    8.5
#define LETTER_HEIGHT  14.0
#define LEGAL_WIDTH     8.5
#define LEGAL_HEIGHT   14.0 
#define US_WIDTH        8.5
#define US_HEIGHT      11.0

