// timfx 
// Copyright 2002, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KINO_OPENGL_UTILITY_H
#define KINO_OPENGL_UTILITY_H

#include "kino_plugin_types.h"

#include <GL/gl.h>
#include <GL/glx.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <gdk/gdkx.h>

namespace kino
{

namespace gl
{

/// RAII class for storing OpenGL matrices on the stack
class push_matrix
{
public:
	push_matrix(const GLenum MatrixType);
	~push_matrix();
	
private:
	const GLenum m_matrix_type;
};

/// RAII class for storing OpenGL attributes on the stack
class push_attributes
{
public:
	push_attributes(const GLenum Attributes);
	~push_attributes();
};

/*
class texture
{
public:
	texture();
	~texture();
	
	void bind();
	
private:
	class implementation;
	implementation* const m_implementation;
};
*/

/// Encapsulates off-screen rendering operations for OpenGL
class render_buffer
{
public:
	/// Initializes the size of the buffer in pixels
	render_buffer(const kino::pixel_size_type Width, const kino::pixel_size_type Height);
	~render_buffer();

	/// Must be called before using the buffer for OpenGL drawing
	void start_render();
	/// Fills the buffer with the supplied image
	void draw_background(const kino::pixel_size_type Width, const kino::pixel_size_type Height, void* Pixels);
	/// Disables interlaced rendering
	void render_frame();
	/// Enables interlaced rendering to the given field (0 == even, 1 == odd)
	void render_field(const unsigned int Field);
	/// Must be called after drawing
	void finish_render();
	/// Reads the contents of the buffer
	void read_pixels(const kino::pixel_size_type Width, const kino::pixel_size_type Height, uint8_t* Pixels, const int Format = GL_RGB);
	
	class implementation;

private:
	implementation* const m_implementation;
};

/** By default, render_buffer objects will take advantage of the GLX pbuffer extension for
hardware-accelerated off-screen rendering where available.  Call use_pbuffers(false) to
disable this behavior and use the fallback GLXPIxmaps exclusively */
void use_pbuffers(const bool Enable);

} // namespace gl

} // namespace kino

#endif // !KINO_OPENGL_UTILITY_H
