/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTESTPROPDLG_H
#define CONTESTPROPDLG_H

#include "Contest.H"
#include <wx/wx.h>

class ContestPropDlg : public wxDialog {
public:
  ContestPropDlg (wxWindow* parent, const ContestDesc& cdata = ContestDesc());

  ContestDesc getContestDesc ();

private:
  ContestDesc settings;
  wxStaticText* titleText;
  wxTextCtrl* title;
  wxStaticText* pictureText;
  wxTextCtrl* picture;
  wxStaticText* descrText;
  wxTextCtrl* descr;
  wxStaticText* lessonText;
  wxTextCtrl* lesson;
  wxStaticText* dataText;
  wxTextCtrl* data;
  wxSlider*   weight;

  int width;

  void fillFromSettings ();

  wxSizer* wizardSettingsSizer ();
  wxSizer* lessonSettingsSizer ();
  wxSizer* resultSettingsSizer ();
  wxSizer* buttonSizer ();
  wxSizer* sliderSizer ();

  void onUrlSelectButton (wxCommandEvent& e);
  void onFileSelectButton (wxCommandEvent& e);
  void onTestWizardButton (wxCommandEvent& e);
  void onShowResultsButton (wxCommandEvent& e);
  void onSaveButton (wxCommandEvent& e);

  DECLARE_EVENT_TABLE()
};

#endif
