# dialog.tcl -- Make TkDVI dialog windows.
# Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>.
# See file COPYING for conditions on use and distribution.
# $Id: dialog.tcl,v 1.1.1.1 1999/06/10 12:36:50 lingnau Exp $
#
# This code owes a big debt of gratitude to `Effective Tcl/Tk Programming'
# by Mark Harrison and Michael McLennan.

package provide tkdvi::dialog 0.1

namespace eval tkdvi::dialog {
    proc new {top class} {
	if {[string compare $top {}] == 0} {
	    set count 0
	    set top ".dialog[incr count]"
	    while {[winfo exists $top]} {
		set top ".dialog[incr count]"
	    }
	}

	toplevel $top -class $class
	wm title $top $class
	wm group $top .

	frame $top.content
	frame $top.sep -borderwidth 2 -height 1 -relief sunken
	frame $top.buttons
	pack $top.content -padx 3 -pady 3 -fill both -expand yes
	pack $top.sep -fill x -pady 3
	pack $top.buttons -padx 3 -pady 3 -fill x

	after idle [format {
	    update idletasks
	    wm minsize %s [winfo reqwidth %s] [winfo reqheight %s]
	} $top $top $top] ;# \}
	return $top
    }

    proc content {top} { return "$top.content" }
    proc buttons {top} { return "$top.buttons" }

    proc wait {top var} {
	_safeguard $top
	update
	set sh [winfo screenheight $top]
	set sw [winfo screenwidth $top]
	wm geometry $top [format {+%s+%s} \
		[expr {($sw - [winfo rootx .] - [winfo width $top])/2}] \
		[expr {($sh - [winfo rooty .] - [winfo height $top])/2}]]
	wm deiconify $top
	grab set $top
	vwait $var
	grab release $top
	wm withdraw $top
    }

    bind modalDialog <ButtonPress> {
	wm deiconify %W
	raise %W
    }

    proc _safeguard {top} {
	if {[lsearch [bindtags $top] modalDialog] < 0} {
	    bindtags $top [linsert [bindtags $top] 0 modalDialog]
	}
    }
}
