namespace eval du {
    variable du

    # Define the du array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set du {
	list.reset ""
	list.clear ""
	entry.file ""
	entry.path ""
	dialog ""
	file ""
	path ""
	all_files ""
	bytes ""
	total ""
	kilobytes ""
	count_links ""
	summarize ""
	one_file_system ""
	dereference ""
	dereference_args ""
	seperate_dirs ""
	help ""
	version ""
    }
}

# du::create --
#
#   Method to create the dialog box for the du command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::create { } {
    global tkWorld
    variable du

    # Put the focus on the du dialog if it is already open.
    if [winfo exists $du(dialog)] {
	switch -- [wm state $du(dialog)] {
	    normal {
		raise $du(dialog)
	    }
	    withdrawn -
	    iconic {
		wm deiconify $du(dialog)
	    }
	}
	focus $du(dialog)
	return
    } else {
	set du(dialog) [dialog::create .du Du]
    }

    # There is only 1 tab.
    set tab1 [tabnotebook::page [dialog::interior \
	    $du(dialog)] "Options"]

    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
	    -class TabnotebookFrame]
    button $f1.file_button \
	    -text "File" \
	    -width 12 \
	    -command du::open
    set du(entry.file) [entry $f1.entry_file \
	    -width 35 \
	    -textvariable du::du(file)]
    label $f1.label_path \
	    -text "Start Path" \
	    -width 15 \
	    -anchor e
    set du(entry.path) [entry $f1.entry_path \
	    -width 35 \
	    -textvariable du::du(path)]
    label $f1.label_dereference_args \
	    -text "Dereference Links" \
	    -anchor e \
	    -width 15
    set du(entry.dereference_args) [entry $f1.entry_dereference_args \
	    -width 35 \
	    -textvariable du::du(dereference_args)]
    grid $f1.label_path $f1.entry_path \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f1.file_button $f1.entry_file \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f1.label_dereference_args $f1.entry_dereference_args \
	    -padx 2 \
	    -pady 2 \
	    -sticky w

    # Now build the checkbox items.
    set f2 [frame $tab1.f2 \
	    -class TabnotebookFrame]
    checkbutton $f2.all_files \
	    -text "All Files" \
	    -variable du::du(all_files) \
	    -onvalue "a" \
	    -offvalue ""
    checkbutton $f2.bytes \
	    -text "Bytes" \
	    -variable du::du(bytes) \
	    -onvalue "b" \
	    -offvalue ""
    checkbutton $f2.total \
	    -text "total" \
	    -variable du::du(total) \
	    -onvalue "c" \
	    -offvalue ""
    checkbutton $f2.kilobytes \
	    -text "Kilobytes" \
	    -variable du::du(kilobytes) \
	    -onvalue "k" \
	    -offvalue ""
    checkbutton $f2.count_links \
	    -text "Count Links" \
	    -variable du::du(count_links) \
	    -onvalue "l" \
	    -offvalue ""
    checkbutton $f2.summarize \
	    -text "Summarize" \
	    -variable "du::du(summarize)" \
	    -onvalue "s"\
	    -offvalue ""
    checkbutton $f2.one_file_system \
	    -text "One File System" \
	    -variable du::du(one_file_system) \
	    -onvalue "x" \
	    -offvalue ""
    checkbutton $f2.dereference \
	    -text "Dereference" \
	    -variable du::du(dereference) \
	    -onvalue "L" \
	    -offvalue ""
    checkbutton $f2.seperate_dirs \
	    -text "Seperate Directories" \
	    -variable du::du(seperate_dirs) \
	    -onvalue "S" \
	    -offvalue ""
    checkbutton $f2.help \
	    -text "Help" \
	    -variable du::du(help) \
	    -onvalue "-help" \
	    -offvalue ""
    checkbutton $f2.version \
	    -text "Version" \
	    -variable du::du(version) \
	    -onvalue "-version" \
	    -offvalue ""
    grid $f2.all_files $f2.bytes $f2.total \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid  $f2.kilobytes $f2.count_links $f2.summarize \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f2.one_file_system $f2.dereference $f2.seperate_dirs \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f2.help $f2.version \
	    -padx 2 \
	    -pady 2 \
	    -sticky w

    # Build the only tab.
    pack $f1 $f2 \
	    -side top \
	    -fill x \
	    -padx 5 \
	    -pady 5 \
	    -ipadx 5 \
	    -ipady 5

    # Duhhhhhh......
    focus $du(entry.file)

    # Define the lists for the reset and clear methods
    set du(list.reset) "all_files bytes total kilobytes count_links \
	    summarize one_file_system dereference seperate_dirs \
	    help version"
    set du(list.clear) "file path dereference_args"
}

# du::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::ok { } {
    global tkWorld
    variable du

    # Insert the Tcl command list in the Command Center with the
    # proper formatting of a space between each argument on the
    # command line.  If there are no options given by the user,
    # then don't display it in the CC.

    $tkWorld(cmd_center) insert insert "du "

    # Build the command line argument.
    set cmd_arg ""
    foreach x $du(list.reset) {
	if [string length $du($x)] {
	    append cmd_arg $du($x)
	}
    }
    if [string length $cmd_arg] {
	$tkWorld(cmd_center) insert insert "-$cmd_arg "
    }

    # Insert the users links to dereference.
    if [string length $du(dereference_args)] {
	$tkWorld(cmd_center) insert insert "-D $du(dereference_args) "
    }
    
    # Insert the path if specified.
    if [string length $du(path)] {
	$tkWorld(cmd_center) insert insert "$du(path) "
    }

    # Insert the files that are listed by the user.
    if [string length $du(file)] {
	$tkWorld(cmd_center) insert insert "$du(file) "
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}

# du::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::reset { } {
    variable du

    # Reset all of the list elements.
    foreach x $du(list.reset) {
	set du($x) ""
    }
}

# du::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::clear { } {
    variable du

    # Reset the data structure elements and bg/fg.
    foreach x $du(list.clear) {
	set du($x) ""
	$du(entry.$x) configure -bg #ffffff -fg #000000
    }

    focus $du(entry.file)
}

# du::help --
#
#   Method to invoke the Du Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::help { } {
    global tkWorld

    help::create "help/du.html" "Du Command Help"
}

# du::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::close { } {
    variable du
    
    balloonhelp::cancel
    destroy $du(dialog)
}

# du::open --
#
#   Method to add a file to the file entry and move the cursor
#   index of the entry to the end.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc du::open { } {
    variable du

    # Insert the file list and move the cursor.
    $du(entry.file) insert insert [file::select]
    $du(entry.file) icursor end

    # Set the focus on the entry with the file list in it.
    focus $du(entry.file)
}
