/* tua_4_hdb.h -- Constants and structs definition, functions prototype for HDB-Uucp.
 *
 * This file is part of TUA.
 *
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef _TUA_4_HDB_H
#define _TUA_4_HDB_H

#include "tua.h"

struct xferentry		/* xferstats entry */
{
  char * System;		/* System's name */
  char * User;			/* User's name */
  Julian_t TimeStamp;
  char * PortName;
  direction_t Direction;
  double Bytes;			/* Bytes moved */
  double Time;			/* Time it takes 
				 * (corrected) */
};

struct uucico_log
{
  Julian_t TimeStamp;
  int ProcessId;
  char * Command;
};

extern int EXFUN (GetXferEntry, (FILE *, struct xferentry *));
extern int EXFUN (GetUucicoLog, (FILE *, struct uucico_log *));

#endif /* _TUA_4_HDB_H */
