<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup company
 * @module company_new
 * @package company
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("company","new");
 loadlayout();

 /**
  * change/modify a company
  */
 class company_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     if ( $this->loc != "" ) {
       echo "<form name=\"locadd\" action=\"location_ins.php\" method=\"post\">\n";
     } else {
       echo "<form name=\"cmpadd\" action=\"company_ins.php\" method=\"post\">\n";
     }
     $this->addHidden("id", $this->obj->id);

     echo $this->DataTableStart();
     echo "<tr>\n";
     if ( $this->obj->id < 0 ) {
       echo " <th colspan=\"5\">". sprintf($lang['CompanyCreate'])."</th>\n";
     } else {
       echo " <th colspan=\"5\">". sprintf($lang['CompanyModify'])."</th>\n";
     }
     echo "</tr>\n";
     if ( $this->obj->id > 0 ) {
       echo "<tr>\n";
       if ( $this->loc != "" ) {
         echo " <td colspan=\"5\" align=\"right\">". acl_link($this->loc) ."</td>\n";
       } else {
         echo " <td colspan=\"5\" align=\"right\">". acl_link($this->obj) ."</td>\n";
       }
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['Company'],1,"name");
     if ( $this->loc != "" ) {
       echo "<td colspan=\"4\">". $this->obj->getLink() ."</td>\n";

       # Fields which companies do not use
       $this->addHidden("department","");
       $this->addHidden("c_id",$this->obj->id);
       $this->addHidden("category",2);
       $this->addHidden("cploc",0);
       $this->addHidden("loc_id",$this->loc->id);
     } else {
       echo "<td colspan=\"4\"><input size=\"30\" maxlength=\"30\" id=\"name \"name=\"name\" value=\"". $this->obj->name ."\"></td>\n";
     }
     echo "</tr>\n";

     if ( $this->loc == "" ) {
       # References to modules
       module_addforms($this->user,$this->obj,4);
     }

     if ( $this->loc != "" ) {
       $this->loc->inputform($this);
     }

     echo "<tr>\n";
     if ($this->obj->id > 0 ) {
       submit_reset(0,1,1,1,1,1);
     } else {
       submit_reset(0,-1,1,1,1,1);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     if ( $this->loc != "" ) {
       echo $this->setfocus("locadd.lname");
     } else {
       echo $this->setfocus("cmpadd.name");
     }
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $lang;

     echo "<tr><td>\n";

     if ( $this->obj->mod_ok()  ) {
       if (count($this->obj->location) > 0) {
         DoubleTableStart();
         foreach($this->obj->location as $i => $f) {
           echo "<tr><th colspan=\"2\">". sprintf($lang['AdrLocTitle'],$f->lname) ."</th></tr>\n";
           echo "<tr>\n";
           echo " <td>\n";
           if ( $f->mod_ok() ) {
             echo menulink("company_new.php?id=". $this->obj->id ."&loc_id=". $f->id,$lang['Change'],sprintf($lang['ChangeLocInfo'],$f->lname, $this->obj->getFullName()));
           } else {
              echo $lang['Change'];
           }
           echo "</td><td>\n";
           if ( $f->del_ok() ) {
             echo confirmlink("location_del.php?ref=". $this->obj->id ."&id=". $f->id,$lang['Delete'],sprintf($lang['DeleteLocInfo'],$f->lname, $this->obj->getFullName()));
           } else {
             echo $lang['Delete'];
           }
           echo " </td>\n";
           echo "</tr>\n";
         }
         DoubleTableEnd();
       }
       if ( $this->obj->id > 0  ) {
         echo menulink("company_new.php?id=". $this->obj->id ."&loc_id=-1",$lang['AdrLNew'],sprintf($lang['AdrLNewInfo'],$this->obj->getFullName())) ."<br>";
       }
     }
     echo "<br>\n";

     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new company($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name = $lang['CompanyModify'] .": ". $this->obj->getFullName();
       if ($this->obj->id < 0) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       $this->name = $lang['CompanyCreate'];
       $this->obj->name = $lang['PlsChangeName'];
     }
     $this->obj->read_locs_data();

     if ( isset($_GET['loc_id']) ) {
       $this->loc = new location($this->dbconn);
       if ( $_GET['loc_id'] > 0 ) {
         $this->loc->read($_GET['loc_id']);
         $this->loc->lname = $this->obj->loc[$_GET['loc_id']];
       }
       $i = 0;
       while($i < count($this->loc->larray)) {
         $f = $this->loc->larray[$i];
         if ( isset($_GET[$f]) ) {
           $this->loc->$f = $_GET[$f];
         }
         $i++;
       }
     } else {
       $this->loc = "";
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }

     # menu
     $x = tutos_address::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);
     if ( $this->user->feature_ok(useaddressbook,PERM_NEW) ) {
       $x = array( url => "company_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['CompanyCreateInfo'],
                   category => array("company","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "company_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['CompanyDelInfo'],$this->obj->getFullName()),
                   category => array("company","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->id > 0 ) {
       $x = array( url => "company_show.php?id=".$this->obj->id,
                   text => $lang['AdrSeeEntry'],
                   info => sprintf($lang['AdrSeeEntryI'],$this->obj->getFullName()),
                   category => array("company","view")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new company_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: company_new.php,v 1.52.2.2 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->
