
// Copyright (c) 1995-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com

//---------------------------------------------------------------------------
// 
// $Id: STDTypes.hh,v 1.1 2003/12/04 19:13:18 dmartin Exp $
// 
//---------------------------------------------------------------------------

#ifndef STDTYPES_HH
#define STDTYPES_HH

#include <iostream>
#include <sstream>
#include <string.h>

#ifdef HAVE_STDINT_H
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS
#endif
#include <stdint.h>
#endif

using std::ostream;
using std::ostringstream;
using std::cout;
using std::cerr;
using std::endl;

#include "tyvis/vhdl.hh"
#include "tyvis/VHDLData.hh"
#include "tyvis/Types.hh"

class AccessVariable;
class AccessType;


#include "tyvis/UniversalBoolean.hh"
#include "tyvis/UniversalCharacter.hh"
#include "tyvis/_savant_severity_level.hh"

struct UniversalReal;
struct UniversalLongLongInteger;

#include "tyvis/UniversalInteger.hh"
#include "tyvis/UniversalLongLongInteger.hh"
#include "tyvis/UniversalReal.hh"
#include "tyvis/_savant_file_open_kind.hh"
#include "tyvis/_savant_file_open_status.hh"
#include "tyvis/KernelTypes.hh"

inline ostream& operator<<(ostream& os, const VHDLData::Side_t& s) {
  switch (s) {
  case VHDLData::LEFT:
    os << "LEFT";
    break;
  case VHDLData::RIGHT:
    os << "RIGHT";
    break;
  default:
    os << "(invalid Side type)";
    break;
  }
  return os;
}



inline bool savantAnd( bool lhs, bool rhs ) {
  return lhs && rhs;
}

inline bool savantOr(bool lhs, bool rhs) {
  return lhs || rhs;
}

inline bool savantNand(bool lhs, bool rhs) {
  return !(lhs && rhs);
}

inline bool savantNor(bool lhs, bool rhs) {
  return !(lhs || rhs);
}

inline bool savantXor(bool lhs, bool rhs) {
  return ((lhs && !rhs) || (!lhs && rhs));
}

inline bool savantXnor(bool lhs, bool rhs) {
  return (!((lhs && !rhs) || (!lhs && rhs)));
}

inline bool savantNot(bool rhs) {
  return !rhs;
}

#endif
