#ifndef UNIVERSAL_CHARACTER_HH
#define UNIVERSAL_CHARACTER_HH

#include <iostream>
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
#include "tyvis/VHDLData.hh"
using std::cout;
using std::cerr;
using std::endl;
class AccessVariable;

struct UniversalCharacter : public VHDLData {
  friend inline ostream& operator<<(ostream&, const UniversalCharacter&);

  char val;

  virtual VHDLData::UniversalType getUniversalKind() const{
    return UNIVERSAL_CHARACTER;
  }

  UniversalCharacter() { val = '\0'; }
  UniversalCharacter(char c) { val = c;}

  UniversalCharacter(bool b) {
    if(b == true) {
      val = '1';
    }
    else {
      val = '0';
    }
  }

  UniversalCharacter(int value) {
    val = value % 256;
  }

  UniversalCharacter(double value) {
    value = value;
    cerr << "wrong type passed " << endl;
    abort();
  }

  UniversalCharacter(const UniversalCharacter& c) : VHDLData() { val = c.val; }
  UniversalCharacter(const VHDLData& v);

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const UniversalCharacter &>( compareTo.readVal() ).val;
  }

  bool operator!=(const RValue &compareTo ) const {
    return val != dynamic_cast<const UniversalCharacter &>( compareTo.readVal() ).val;
  }

  bool operator>( const RValue &compareTo ) const{
    return val > dynamic_cast<const UniversalCharacter &>( compareTo.readVal() ).val;
  }

  bool operator>=( const RValue &compareTo ) const {
    return val >= dynamic_cast<const UniversalCharacter &>( compareTo.readVal() ).val;
  }

  bool operator<( const RValue &compareTo ) const {
    return val < dynamic_cast<const UniversalCharacter &>( compareTo.readVal() ).val;
  }

  bool operator<=( const RValue &compareTo ) const {
    return val <= dynamic_cast<const UniversalCharacter &>( compareTo.readVal() ).val;
  }

  UniversalCharacter &operator=( const UniversalCharacter &c ){
    val = c.val;
    return *this;
  }

  VHDLData& operator=(const VHDLData &assignFrom ) {
    val = dynamic_cast<const UniversalCharacter &>( assignFrom ).val;
    return *this;
  }

  operator char() { return val;}

  UniversalCharacter assign(char ch) { 
    val = UniversalCharacter(ch);
    return val;
  }

  int savantwrite(AccessVariable &) const;
  int savantwrite(AccessType &) const;
  int savantread(AccessVariable &);
  int savantread(AccessType &);
  int savantread(char *) {
    return NORMAL_RETURN;
  }
  int savantwrite( ostringstream &os ) const {
    os << this->val;
    return NORMAL_RETURN;
  }
  
  VHDLData* clone() const {
    return new UniversalCharacter(*this);
  }
  
  void print(ostream& os = cout) const { os << *this; os.flush(); }

  static const string &getUniversalCharacterType(){
    static const string universalCharacterType = "UniversalCharacter";
    return universalCharacterType;
  }

  const string &getDataType() const {
    return getUniversalCharacterType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt( (int)val );
  }
  
  static Serializable *deserialize( SerializedInstance *si ){
    return new UniversalCharacter( (char)si->getInt() );
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getUniversalCharacterType(),
							   &UniversalCharacter::deserialize );
  }

  int getIntValue() const { return val; }
  LONG getInt64Value() const { return (LONG)val; }
  double getDoubleValue() const { return (double)val; }
};

inline ostream& operator<<(ostream& os, const UniversalCharacter& c) {
  os << c.val;
  return os;
}

#endif
