
#include <ubit/ubit.hpp>


class PerspBar: public UButton {
public:
  UScale   colscale;
  UBgcolor bgcolor;
  PerspBar(UArgs);
  void setScale(int scale);
  void setBgcolor(const UColor&);
};


class Persp: public UPane {
public:
  enum Mode {flat, fixedFocusBar, movingFocusBar}; 
public:
  int mag_more, mag_factor, mag_min;
  Mode  mode;
  int   focus;
  UBgcolor *barBgcolor, *focusBarBgcolor;
  u_pos focusBarOffset;
  UHbox bar_container;
  UStr  focus_str;

public:
  // NOTE: columns (and nothing else!) must be added by using 
  // the add() method (and must not be given as initial args)
  Persp(UArgs);

  void addBar(PerspBar*, int pos = -1);
  void addBar(PerspBar&, int pos = -1);

  void setFocus(int focus);
  void replace(UEvent&);
  void setFocusBarOffset(u_pos offset);
  void goLeft();
  void goRight();
  void goSelf(UEvent&, PerspBar*);

  void setMagFactor(int);
  void setMode(Mode);

  int  getMagFactor() const {return mag_factor;}
  Mode getMode()      const {return mode;}

  int getFocus() {return focus;}
  // returns an UStr that indicates the current focus
  UStr& getFocusStr() {return focus_str;}
};


