/* ==================================================== ======== ======= *
 *
 *  utable.hh
 *  Ubit Project [Elc::003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _utable_hh
#define	_utable_hh
//pragma ident	"@(#)utable.hh	ubit:03.06.00"
#include <ubit/ubox.hpp>


/** UTable = class for creating (simplified) HTML like tables.
 *  NOTE: an UTable is an UBox with UTableView renderer
 *  - See also: UTrow, UTcell
 */
class UTable: public UBox {
public:
  static UStyle *style;

  UTable(const UArgs& a = UArgs::none);
  friend UTable& utable(const UArgs& a = UArgs::none);

  virtual const UStyle& getStyle(UContext*) const {return makeStyle();}
  static  const UStyle& makeStyle();
};


/** Table Row.
 *  NOTE: MUST be a child of a UTable object
 *  - See also: UTable, UTcell
 */
class UTrow: public UGroup {
public:
  static UStyle *style;

  UTrow(const UArgs& a = UArgs::none);
  friend UTrow& utrow(const UArgs& a = UArgs::none);

  virtual const UStyle& getStyle(UContext*) const {return makeStyle();}
  static  const UStyle& makeStyle();
};


/** Table Cell.
 *  NOTE: MUST be a child of a UTrow object
 *  - See also: UTable, UTrow
 */
class UTcell: public UFlowbox {
  short colspan, rowspan;
public:
  static UStyle *style;

  UTcell(const UArgs& a = UArgs::none);
  UTcell(short colspan, const UArgs& a = UArgs::none);
  UTcell(short colspan, short rowspan, const UArgs& a = UArgs::none);

  friend UTcell& utcell(const UArgs& a = UArgs::none);
  friend UTcell& utcell(short colspan, const UArgs& a = UArgs::none);
  friend UTcell& utcell(short colspan, short rowspan, const UArgs& a = UArgs::none);

  virtual const UStyle& getStyle(UContext*) const {return makeStyle();}
  static  const UStyle& makeStyle();

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  void  setColspan(short);
  void  setRowspan(short);

  short getColspan() {return colspan;}
  short getRowspan() {return rowspan;}
};

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

/** TableView Renderer
 * see also: UTable
 */
class UTableView: public UView {
public:
  static  UViewStyle style;  // renderer
  virtual UViewStyle* getViewStyle() {return &style;}

  // "static" constructor used by UViewStyle to make a new view
  static UView* makeView(UBoxLink*, UView* parview, UWinGraph*);

  UTableView(UBoxLink*, UView* parview, UWinGraph*);
  virtual ~UTableView();

#ifndef NO_DOC
  class UViewCell *cols, *lines;
  int lcur, ccur, ccount, cmax, lcount, lmax; 
  virtual bool doLayout(UContext&, class UViewLayout &vl);
#endif
};

struct UViewCell {
  u_dim min_dim, max_dim, spec_dim;
  int rowspan, colspan;
  static UViewCell* augment(UViewCell *tab, int *count, int span);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:02] ======= */

