/* ==================================================== ======== ======= *
 *
 *  uhtmltags.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uhtmltags_hpp_
#define _uhtmltags_hpp_
//pragma ident	"@(#)uxmltags.hpp	ubit:03.06.03"

#include <ubit/ubit.hpp>
#include <ubit/xml/uxmldefs.hpp>

// ========================================================================
// ELEMENTS

class UHtml_head : public UGroup, public UXmlElem {
public:
  UHtml_head(DOMElement* e);
  static UBrick* create(DOMElement* e) {return new UHtml_head(e);}
};

class UHtml_title : public UBrick, public UXmlElem {
public:
  UHtml_title(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_title(e);}
};

class UHtml_stitle : public UBrick, public UXmlElem {
public:
  UHtml_stitle(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_stitle(e);}
};

class UHtml_link : public UBrick, public UXmlElem {
public:
  UHtml_link(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_link(e);}
};

class UHtml_meta : public UBrick, public UXmlElem {
public:
  UHtml_meta(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_meta(e);}
};

class UHtml_style : public UBrick, public UXmlElem {
public:
  UHtml_style(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_style(e);}
};

/* ==================================================================== */

class UHtml_body : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_body(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_body(e);}
};

class UHtml_div : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_div(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_div(e);}
};

class UHtml_p : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*t) const;

  UHtml_p(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_p(e);}
};

class UHtml_pre : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_pre(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_pre(e);}
};

class UHtml_blockquote : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_blockquote(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_blockquote(e);}
};

class UHtml_br : public UStr, public UXmlElem {
public:
  UHtml_br(DOMElement* e);
  static UBrick* create(DOMElement* e) {return new UHtml_br(e);}
  virtual void createChildren(class UXmlDoc*, class UDoc::Errors&) {}  // no children
};

// ======================================================================

class UHtml_ul : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_ul(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement*e) {return new UHtml_ul(e);}
};

class UHtml_ol : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_ol(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement*e) {return new UHtml_ol(e);}
};

class UHtml_li : public UFlowbox, public UXmlElem {
  int isfirstelem;
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_li(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_li(e);}
};

// =======================================================================

class UHtml_h1 : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_h1(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_h1(e);}
};

class UHtml_h2 : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_h2(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_h2(e);}
};

class UHtml_h3 : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_h3(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_h3(e);}
};

class UHtml_h4 : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_h4(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_h4(e);}
};

class UHtml_h5 : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_h5(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_h5(e);}
};

class UHtml_h6 : public UFlowbox, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_h6(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_h6(e);}
};

// ======================================================================

class UHtml_table : public UTable, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  //  UHtml_table(DOMElement* e) : UXmlElem(e) {}
  UHtml_table(DOMElement* e);
  static UBrick* create(DOMElement* e) {return new UHtml_table(e);}
};

class UHtml_tr : public UTrow, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_tr(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_tr(e);}
};

class UHtml_td : public UTcell, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_td(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_td(e);}
};

class UHtml_th : public UTcell, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_th(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_th(e);}
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class UHtml_a : public UXmlLinkElem, public ULinkbutton {
public:
  //static UStyle *style;
  //virtual const UStyle& getStyle(UContext*) const;

  UHtml_a(DOMElement* e) : UXmlLinkElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_a(e);}
  virtual void createChildren(class UXmlDoc*, class UDoc::Errors&);
};

// =====================================================================

class UHtml_img : public UXmlObjectElem, public UIma  {
public:
  UHtml_img(DOMElement* e) : UXmlObjectElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_img(e);}
  virtual void createChildren(class UXmlDoc*, class UDoc::Errors&);
  virtual bool isLoaded() const;  ///< redef of UDoc::Object && UIma
  virtual int load();            ///< redef of UDoc::Object && Uima
};

// ======================================================================
// ======================================================================

class UHtml_span : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_span(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_span(e);}
};

class UHtml_b : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_b(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_b(e);}
};

class UHtml_i : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_i(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_i(e);}
};

class UHtml_em : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_em(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_em(e);}
};

class UHtml_u : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_u(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_u(e);}
};

class UHtml_font : public UGroup, public UXmlElem {
public:
  static UStyle *style;
  virtual const UStyle& getStyle(UContext*) const;

  UHtml_font(DOMElement* e) : UXmlElem(e) {}
  static UBrick* create(DOMElement* e) {return new UHtml_font(e);}
};

// =========================================================================
// =========================================================================
// ATTRIBUTES

class UHtml_align : public UHalign, public UXmlAttr {
public:
  UHtml_align(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_align(a,e);}
};


class UHtml_valign : public UValign, public UXmlAttr {
public:
  UHtml_valign(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_valign(a,e);}
};

// ===========================================================================

class UHtml_color : public UColor, public UXmlAttr {
public:
  UHtml_color(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e)
  {return new UHtml_color(a,e);}
};


class UHtml_bgcolor : public UBgcolor, public UXmlAttr {
public:
  UHtml_bgcolor(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_bgcolor(a,e);}
};


// ===========================================================================

class UHtml_border : public UBrick, public UXmlAttr {
  int val;
public:
  UHtml_border(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_border(a,e);}

  int getValue() const {return val;}
};


class UHtml_width : public UBrick, public UXmlAttr {
  int val;
public:
  UHtml_width(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_width(a,e);}

  int getValue() const {return val;}
};

// ===========================================================================

class UHtml_cellspacing : public UBrick, public UXmlAttr {
  int val;
public:
  UHtml_cellspacing(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_cellspacing(a,e);}

  int getValue() const {return val;}
};


class UHtml_cellpadding : public UBrick, public UXmlAttr {
  int val;
public:
  UHtml_cellpadding(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_cellpadding(a,e);}

  int getValue() const {return val;}
};

// ===========================================================================

class UHtml_colspan : public UBrick, public UXmlAttr {
  int val;
public:
  UHtml_colspan(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e)
  {return new UHtml_colspan(a,e);}

  int getValue() const {return val;}
};


class UHtml_rowspan : public UBrick, public UXmlAttr {
  int val;
public:
  UHtml_rowspan(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_rowspan(a,e);}

  int getValue() const {return val;}
};


class UHtml_nowrap : public UBrick, public UXmlAttr {
public:
  UHtml_nowrap(DOMAttr*, UDoc::Errors&);

  static UBrick* create(DOMAttr*a, UDoc::Errors&e) 
  {return new UHtml_nowrap(a,e);}
};

// ===========================================================================

class UHtml_xmlns : public UBrick, public UXmlAttr {
public:
  UHtml_xmlns(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_xmlns(a,e);}
};

class UHtml_http_equiv : public UBrick, public UXmlAttr {
public:
  UHtml_http_equiv(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_http_equiv(a,e);}
};

class UHtml_content : public UBrick, public UXmlAttr {
public:
  UHtml_content(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_content(a,e);}
};

class UHtml_class : public UBrick, public UXmlAttr {
public:
  UHtml_class(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_class(a,e);}
};

class UHtml_name : public UBrick, public UXmlAttr {
public:
  UHtml_name(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_name(a,e);}
};

class UHtml_type : public UBrick, public UXmlAttr {
public:
  UHtml_type(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_type(a,e);}
};

class UHtml_target : public UBrick, public UXmlAttr {
public:
  UHtml_target(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_target(a,e);}
};

class UHtml_src : public UBrick, public UXmlAttr {
public:
  UHtml_src(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_src(a,e);}
};

class UHtml_href : public UBrick, public UXmlAttr {
public:
  UHtml_href(DOMAttr* a, UDoc::Errors&) : UXmlAttr(a) {}

  static UBrick* create(DOMAttr*a, UDoc::Errors& e)
  {return new UHtml_href(a,e);}
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

