/* ==================================================== ======== ======= *
 *
 *  uxmlparser.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uxmlparser_hpp_
#define _uxmlparser_hpp_
//pragma ident	"@(#)uxmlparser.hpp	ubit:03.06.00"

#include <ubit/xml/uxmldoc.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/** XML Parser.
 * Implementation.
 * Clients should use classes UHtmlReader or UDoc except if they don't
 * want to create the Ubit instance tree.
 */
class UXmlParser {
public:
  UXmlParser();
  /**< creates the XML Parser, which can be used for parsing several documents.
  * this class is an interface to the Apache Xerces library
  */

  ~UXmlParser();

  DOMDocument* parse(const UStr& pathname, UDoc::Errors&);
  /**<
    * opens and parses an XML document.
    * the returned DOMDocument should be destroyed by clients.
    * Note: the XmlDoc can reference an URL.
    */

  static void terminate();
  /**< can (optionally) be called to release memory.
    * this function releases Xerces data. There is usuallay no need to call it.
    */

protected:
  static bool xerces_initialized;
  XercesDOMParser* xerces_parser;
  ErrorHandler* xerces_error_handler;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

