/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include <stdio.h>

#include "types.h"

void FUNCTIONS_add(Function *f);
Function *FUNCTIONS_new_from_label(Label *l);
Function *FUNCTIONS_find_from_label(Label *l);
Label *FUNCTIONS_get_label(Function *f);
char *FUNCTIONS_name(Function *f);

void FUNCTIONS_add_localvar(Function *f, Variable *v);
Variable *FUNCTIONS_new_localvar(Function *f, int offset, VarType vartype);
Variable *FUNCTIONS_find_localvar(Function *f, int offset, VarType vartype);
Variable *FUNCTIONS_find_or_new_localvar(Function *f, int offset, VarType vartype);

void FUNCTIONS_add_argument(Function *f, Variable *v);
Variable *FUNCTIONS_new_argument(Function *f, int offset, VarType vartype);
Variable *FUNCTIONS_find_argument(Function *f, int offset, VarType vartype);
Variable *FUNCTIONS_find_or_new_argument(Function *f, int offset, VarType vartype);
int FUNCTIONS_count_arguments(Function *f);
void FUNCTIONS_sort_arguments();

void FUNCTIONS_set_frame_pointer(Function *f, Register *r);
Register *FUNCTIONS_get_frame_pointer(Function *f);

Variable *FUNCTIONS_find_var(Function *f, int offset, VarType vartype);
char *FUNCTIONS_var_name(Variable *v);

void FUNCTIONS_add_body_line(Function *f, Expr *l);

void FUNCTIONS_print(FILE *target);

Function *FUNCTIONS_first();
Function *FUNCTIONS_next(Function *f);

void FUNCTIONS_set_frame_size(Function *f, int size);
int FUNCTIONS_get_frame_size(Function *f);

void FUNCTIONS_set_external(Function *f);
void FUNCTIONS_unset_external(Function *f);
int FUNCTIONS_is_external(Function *f);

#endif

