/* $Id: mail.c,v 1.7 2002/10/30 19:27:09 bjk Exp $ */
/*
    Copyright (C) 2001-2002  Ben Kibbey <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include "common.h"

static void aliases(INFO * info)
{
    char t[LINE_MAX];
    static int firstrun;
    int i, n;
    struct stat st;

    if ((!aliasbuf && firstrun) || aliasbuf == MAP_FAILED) {
	strcpy(info->mail->aliases, UNKNOWN);
	return;
    }

    if (!aliasbuf) {
	firstrun = 1;

	if (stat(ALIAS_FILE, &st) == -1) {
	    strcpy(info->mail->aliases, UNKNOWN);
	    return;
	}

	if ((aliasfd = open(ALIAS_FILE, O_RDONLY)) == -1) {
	    strcpy(info->mail->aliases, UNKNOWN);
	    return;
	}

	if ((aliasbuf = mmap(0, st.st_size, PROT_READ, MAP_PRIVATE, aliasfd,
			0)) == MAP_FAILED) {
	    warn("%s", "mmap()");
	    strcpy(info->mail->aliases, UNKNOWN);
	    return;
	}
    }

    for (i = n = 0; aliasbuf[i]; i++) {
	char *last, *name, *tmp;

	while (aliasbuf[i] != '\n')
	    t[n++] = aliasbuf[i++];

	t[n] = 0;
	n = 0;

	if (t[0] == '#' || t[0] == 0)
	    continue;

	last = t;

	if ((name = strsep(&last, ":")) == NULL)
	    continue;

	if (strcmp(info->passwd->pw_name, name) == 0) {
	    while ((tmp = strsep(&last, ",")) != NULL) {
		tmp = stripstr(tmp, " \n\t");

		strcat(info->mail->aliases, tmp);
		strcat(info->mail->aliases, ",");
	    }

	    continue;
	}

	while ((tmp = strsep(&last, ",")) != NULL) {
	    tmp = stripstr(tmp, " \n\t");

	    if (strcmp(info->passwd->pw_name, tmp) == 0) {
		strcat(info->mail->aliases, name);
		strcat(info->mail->aliases, ",");
	    }
	}
    }

    if (info->mail->aliases[0] == 0)
	strcpy(info->mail->aliases, NONE);
    else
	info->mail->aliases[strlen(info->mail->aliases) - 1] = 0;

    return;
}

static void forwardaddr(INFO * info)
{
    FILE *fp;
    char buf[LINE_MAX], *s, filename[FILENAME_MAX];
    int n = 0;

    snprintf(filename, sizeof(filename), "%s/.forward", info->passwd->pw_dir);

    if ((fp = fopen(filename, "r")) == NULL) {
	if (errno == ENOENT)
	    strcpy(info->mail->forward, NONE);
	else
	    strcpy(info->mail->forward, UNKNOWN);

	return;
    }

    while ((s = fgets(buf, sizeof(buf), fp)) != NULL) {
	if (buf[0] == '\n')
	    continue;

	buf[strlen(buf) - 1] = 0;

	if (n++)
	    strcat(info->mail->forward, ",");

	strcat(info->mail->forward, buf);
    }

    fclose(fp);

    if (!n)
	strcpy(info->mail->forward, NONE);

    return;
}

static int folderstat(const char *user, struct stat *st)
{
    char folder[FILENAME_MAX];

    snprintf(folder, sizeof(folder), "%s/%s", _PATH_MAILDIR, user);

    return stat(folder, st);
}

void mailinfo(INFO * info, const char *arg)
{
    int i, gotstat = 0;
    struct stat st;

    if (info->mail == NULL)
	info->mail = Malloc(sizeof(MAIL));

    memset(info->mail, 0, sizeof(MAIL));

    if (folderstat(info->passwd->pw_name, &st) != -1)
	gotstat = 1;

    for (i = 0; i < ARRAYCNT(optspec) && optspec[i]; i++) {
	switch (optspec[i]) {
	    case 'o':
		forwardaddr(info);
		break;
	    case 'z':
		info->mail->foldersize = (gotstat) ? st.st_size : -1;
		break;
	    case 'r':
		strcpy(info->mail->lastread, (gotstat) ?
			stamp(st.st_atime, tf) : UNKNOWN);
		break;
	    case 'w':
		strcpy(info->mail->newstamp, (gotstat) ?
			stamp(st.st_mtime, tf) : UNKNOWN);
		break;
	    case 'a':
		aliases(info);
		break;
	    default:
		break;
	}
    }

    return;
}
