/* $Id: output.c,v 1.8 2002/10/30 00:23:37 bjk Exp $ */
/*
    Copyright (C) 2001-2002  Ben Kibbey <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <pwd.h>
#include <errno.h>
#include "common.h"

#ifndef ALLPERMS
#define ALLPERMS	(S_ISUID|S_ISGID|S_IRWXU|S_IRWXG|S_IRWXO)
#endif

static void outputlastinfo(INFO * info, const char *opts)
{
    int i = 0;

    while (*opts) {
	if (i)
	    printf("%c", delimchar);

	switch (*opts++) {
	    case 'y':
		printf("%s", info->lastinfo->tty);
		break;
	    case 'h':
		printf("%s", info->lastinfo->host);
		break;
	    case 't':
		printf("%s", info->lastinfo->time);
		break;
	    case 'a':
		outputlastinfo(info, "yht");
		break;
	    default:
		break;
	}

	i++;
    }

    return;
}

static void outputgecos(INFO * info, const char *opts)
{
    int i = 0;

    while (*opts) {
	if (i)
	    printf("%c", delimchar);

	switch (*opts++) {
	    case 'n':
		printf("%s", info->gecos->name);
		break;
	    case 'o':
		printf("%s", info->gecos->office);
		break;
	    case 'w':
		printf("%s", info->gecos->officephone);
		break;
	    case 'h':
		printf("%s", info->gecos->homephone);
		break;
	    case 'a':
		outputgecos(info, "nowh");
		break;
	    default:
		break;
	}

	i++;
    }

    return;
}

void outputinfo(INFO * info, const char *arg)
{
    int i, next, first = 0;
    GROUP *gnode, *gcur, *gnext;
    struct stat st;

    if (verbose && usefile)
	printf("%s%c", arg, delimchar);

    for (i = 0; i < MAXOPTIONS; i++) {
	char *tmp;

	if (optspec[i] == 0)
	    break;

	next = 0;

	if (first)
	    printf("%c", delimchar);

	switch (optspec[i]) {
	    case 'C':
		if (info->login->ppid == -1)
		    printf("%s", UNKNOWN);
		else
		    printf("%i", (int)info->login->ppid);
		break;
	    case 'q':
		if (info->login->idle == -1)
		    printf("%s", UNKNOWN);
		else
		    printf("%i", info->login->idle);
		break;
	    case 'o':
		printf("%s", info->mail->forward);
		break;
	    case 'z':
		if (info->mail->foldersize == -1)
		    printf("%s", UNKNOWN);
		else
		    printf("%lu", (unsigned long)info->mail->foldersize);
		break;
	    case 'r':
		printf("%s", info->mail->lastread);
		break;
	    case 'w':
		printf("%s", info->mail->newstamp);
		break;
	    case 'a':
		printf("%s", info->mail->aliases);
		break;
	    case 's':
		printf("%s", info->passwd->pw_shell);
		break;
	    case 'l':
		printf("%s", info->passwd->pw_name);
		break;
#ifdef HAVE_GETSPNAM
	    case 'c':
		if (!amroot) {
		    printf("%s", UNKNOWN);
		    break;
		}

		if (info->spwd->sp_max == 0 || info->spwd->sp_max == 99999) {
		    printf("%s", NONE);
		    break;
		}

		tmp = stamp(info->spwd->sp_max * 86400, tf);

		printf("%s", tmp);
		break;
	    case 'k':
		if (!amroot) {
		    printf("%s", UNKNOWN);
		    break;
		}

		if (info->spwd->sp_expire == 0
		    || info->spwd->sp_expire == 99999) {
		    printf("%s", NONE);
		    break;
		}

		tmp = stamp(info->spwd->sp_expire * 86400, tf);

		printf("%s", tmp);
		break;
#else
	    case 'c':
		if (info->passwd->pw_change == 0) {
		    printf("%s", NONE);
		    break;
		}

		tmp = stamp(info->passwd->pw_change, tf);
		printf("%s", tmp);
		break;
	    case 'k':
		if (info->passwd->pw_expire == 0) {
		    printf("%s", NONE);
		    break;
		}

		tmp = stamp(info->passwd->pw_expire, tf);
		printf("%s", tmp);
		break;
#endif
	    case 'd':
		printf("%s", info->passwd->pw_dir);
		break;
	    case 'u':
		printf("%i", (int)info->passwd->pw_uid);
		break;
	    case 'g':
		for (gnode = info->group; gnode; gnode = gnode->next) {
		    if (gnode->next && next)
			printf("%c", ',');

		    printf("%i", (int)gnode->id);

		    if (verbose)
			printf("(%s)", gnode->name);

		    next++;

		    if (!gnode->next || !gnode->next->name[0])
			break;
		}
		break;
	    case 'p':
#ifdef HAVE_GETSPNAM
		if (amroot)
		    printf("%s", info->spwd->sp_pwdp);
		else
		    printf("%s", info->passwd->pw_passwd);
#else
		printf("%s", info->passwd->pw_passwd);
#endif
		break;
	    case 'm':
		if (lstat(info->passwd->pw_dir, &st) == -1) {
		    printf("%s", UNKNOWN);
		    break;
		}

		printf("%.4o", (unsigned)st.st_mode & ALLPERMS);
		break;
	    case 'i':
		outputgecos(info, gecosopts);
		break;
	    case 'n':
		outputlastinfo(info, lastopts);
		break;
	    case 'e':
		if (info->login->mesgstat == -1)
		    printf("%s", UNKNOWN);
		else
		    printf("%s", (info->login->mesgstat == 1) ? ON : OFF);
		break;
	    case 'y':
		printf("%s", info->login->tty);
		break;
	    case 't':
		printf("%s", info->login->stamp);
		break;
	    case 'b':
		if (info->login->duration == -1)
		    printf("%s", UNKNOWN);
		else if (info->login->duration == -2)
		    printf("%s", NONE);
		else
		    printf("%i", info->login->duration);
		break;
	    case 'x':
		printf("%s", info->login->host);
		break;
	    default:
		break;
	}

	first++;
    }

    printf("%c", '\n');

    if (group_info) {
	for (gcur = info->group; gcur; gcur = gnext) {
	    gnext = gcur->next;
	    free(gcur);
	}
    }

    return;
}
