#!/usr/local/bin/perl
# Show all scheduled messages

require './schedule-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", undef, 0, 1);

@scheds = &list_schedules();
if (@scheds) {
	print "<a href='edit.cgi?new=1'>$text{'index_add'}</a><br>\n";
	print &ui_columns_start([ $text{'index_subject'},
				  $text{'index_when'},
				  $text{'index_to'},
				  $text{'index_enabled'} ], 100);
	foreach $s (@scheds) {
		if ($s->{'at'}) {
			$when = localtime($s->{'at'});
			}
		else {
			$when = &cron::when_text($s, 1);
			}
		print &ui_columns_row([
			"<a href='edit.cgi?id=$s->{'id'}'>".
		        $s->{'subject'}."</a>",
			$when,
			&html_escape($s->{'to'}) || $text{'index_self'},
			$s->{'at'} &&
			 $s->{'ran'} >= $s->{'at'} ? $text{'index_ran'} :
			$s->{'enabled'} ? $text{'yes'}
					: $text{'no'} ]);
		$sent++ if ($s->{'at'} && $s->{'ran'} >= $s->{'at'});
		}
	print &ui_columns_end();
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit.cgi?new=1'>$text{'index_add'}</a><p>\n";

if ($sent) {
	print "<hr>\n";
	print &ui_buttons_start();
	print &ui_buttons_row("clear.cgi", $text{'index_clear'},
					   $text{'index_cleardesc'});
	print &ui_buttons_end();
	}

&ui_print_footer("/", $text{'index'});

