/*
 * Copyright (c) 1993-1994 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: tkwidget.h,v 1.4 96/03/16 13:12:54 van Exp $ (LBL)
 */

#ifndef vat_tkwidget_h
#define vat_tkwidget_h

#include "Tcl.h"
extern "C" {
#include <tk.h>
}

class TkWidget : public TclObject {
    public:
	/* Called when full redraw is needed */
	virtual void draw() = 0;
	/* Called when incremental redraw needed (i.e., no external damage) */
	virtual void update() = 0;

	virtual void resize();
	virtual void handle(const XEvent&);
	void redraw();
	GC lookup_gc(Font fid, const char* fg, const char* bg) const;
	void set_gcv(XGCValues& v, u_long& mask,
		     Font, XColor* fg, XColor* bg) const;
	XColor* getcolor(const char* name, const char* backup) const;
	inline int mono() const { return (mono_); }
    protected:
	TkWidget(const char* path, const char* classname,
		 int reqw, int reqh, u_long extra_events = 0);
	Tk_Window tk_;
	int width_;
	int height_;
	int mono_;
    private:
	Pixmap make_stipple(float level) const;
	static void display(ClientData cd);
	static void handle(ClientData cd, XEvent* ep);

	int callback_pending_;
	int damage_;
};

inline void TkWidget::redraw()
{
	if (!callback_pending_) {
		callback_pending_ = 1;
		Tk_DoWhenIdle(display, (ClientData)this);
	}
}

#endif
