#ifndef __TXTRECV_H                   
#define __TXTRECV_H

#include <vdr/status.h>
#include <vdr/receiver.h>
#include <vdr/thread.h>
#include <vdr/ringbuffer.h>

#include <semaphore.h>


#ifdef ALTERNATIVE_STORAGE

#include <map>
#include <list>
using namespace std;

//first 10 bits
#define SET_PAGE(x,y)    ( (x) |= ((y) & 0x3FF) )
#define GET_PAGE(x)      ( (x) & 0x3FF )
//the next 7 bits
#define SET_SUBPAGE(x,y) ( (x) |= ( ((y) & 0x7F)<<10 ) )
#define GET_SUBPAGE(x)   ( ( (x)>>10 ) & 0x7f )
//last 15 bits
#define SET_CHANNEL(x,y) ( (x) |= ( ((y) & 0x1FFFF)<<17 ) )
#define GET_CHANNEL(x)   ( ( (x)>>17 ) & 0x1FFFF )

typedef map<int,char*> TextPages;
extern TextPages teletextPages;
//typedef list<TextPages::iterator> TextPagesList;
//extern TextPagesList teletextPagesList;
extern cMutex txtMutex;

//one page is 972 bytes.
#define MAX_PAGES_IN_MEMORY 1500

#endif //ALTERNATIVE_STORAGE


class cTelePage {
 private:
  int mag;
  unsigned char flags;
  unsigned char lang;
  int pnum,sub,chnum;
  unsigned char pagebuf[27*40];
  char Directory [255];
 public:
  cTelePage(int,int,int,uchar,uchar,int,char *);
  ~cTelePage();
  void SetLine(int, uchar*);
  void save();
 };

class cRingTxtFrames : public cRingBufferFrame {
 public:
  cRingTxtFrames(int Size) : cRingBufferFrame(Size, true) {};
  ~cRingTxtFrames() { Clear(); };
  void Wait(void) { WaitForGet(); };
  void Signal(void) { EnableGet(); };
  bool Check(int Size) { return (Free() >= Size); };
};

class cTxtReceiver : public cReceiver, public cThread {
 private:
  void DecodeTXT(uchar*);
  uchar unham16 (uchar*);
  int KanalNr;
  cTelePage *TxtPage;
 protected:
  virtual void Receive(uchar *Data, int Length);
  void Action();
#ifdef ALTERNATIVE_STORAGE
  void savePages();
  void loadPages();
#endif
  cRingTxtFrames buffer;
  bool running;
 public:
  cTxtReceiver(int TPid, int ChNum);
  ~cTxtReceiver();
};

class cTxtStatus : public cStatus, public cThread {
 private:
  cTxtReceiver *receiver;
  bool running;
  cCondVar condVar;
  cMutex mutex;
  int count;
  sem_t semaphore;
 protected:
  int TPid;
  int ChNum;
  bool doNotSuspend;
  bool doNotReceive; 
  virtual void ChannelSwitch(const cDevice *Device, int ChannelNumber);
  virtual void Action();
  void CheckCreateReceiver();
  void CheckDeleteReceiver();
 public:
  cTxtStatus(void);
  ~cTxtStatus();
  void ForceReceiving(bool onOrOff);
  void ForceSuspending(bool onOrOff);
};

#endif
