/*
 * Mines
 *
 * Copyright (C) Evan Harris, 1994, 1995.
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#define QUIT 0
#define NEWGAME 1
#define PROTECT 2
#define DETONATE 3
#define CHECK_AROUND 4
#define UNCHECK_AROUND 5

#define CONT 0
#define LOSE 1
#define WIN 2

#define packedcmd_cmd(p) ((p) >> 10)
#define packedcmd_x(p) (((p) >> 5) & 0x1f)
#define packedcmd_y(p) ((p) & 0x1f)
#define packcmd(c, x, y) ((c) << 10 | (x) << 5 | (y))

#define SQ_BLANK 0
#define SQ_X 10
#define SQ_Q 11
#define SQ_COVERED 12
#define SQ_QUERY 13
#define SQ_XFLAG 14
#define SQ_GMINE 15
#define SQ_XMINE 16

void InitDisplay(int w, int h);
void EndDisplay(void);
void NewGame(int w, int h);
void GameOver(int status);
void MinesLeft(int m);
int GetMove(void);
void ShowSquare(int x, int y, int sq);
