/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_IMAGE_WINDOW
#define _H_IMAGE_WINDOW

#include <AppKit/NSApplication.h>
#include <AppKit/NSWindow.h>
#include <AppKit/NSToolbar.h>
#include <AppKit/NSTextView.h>

#include "PDFContentView.h"
#include "FindView.h"

@class DocumentWindowController;
@class ExtendedNSTextView;
@class NSView;
@class NSButton;
@class NSMutableArray;
@class NSProgressIndicator;
@class NSEvent;


@interface DocumentWindow : NSWindow
{
   PDFContentView*            documentView;
   DocumentWindowController*  myController;
   NSToolbar*                 toolbar;
   FindView*                  findView;
   BOOL                       isInFindMode;
   id                         fieldEditor;
}

- (id) init;

- (void) setController: (DocumentWindowController*)controller;
- (void) windowInitializedWithController;

- (PDFContentView*) documentView;

- (void) toggleToolbar;
- (void) enterFindMode;
- (void) exitFindMode;
- (BOOL) isInFindMode;

- (void) keyDown: (NSEvent*)theEvent;

@end


/**
 * Used as the window's field editor.
 */
@interface ExtendedNSTextView : NSTextView
{
   DocumentWindow *window;
}

- (id) initWithFrame: (NSRect)aFrame
       textContainer: (NSTextContainer*)aTextContainer;

- (void) setWindow: (DocumentWindow*)aWindow;

@end

#endif
