/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "Match.h"

/*
 * Non-Public methods.
 */
@interface Match(Private)
@end


/*
 * Holds the informations about a match of a particular
 * search.
 */
@implementation Match

/*
 * Desginated initializer.
 */
- (id) initWithPosition: (DocumentPosition*)_position
                context: (NSString*)_context
             searchText: (NSString*)_searchText
{
   if ((self = [super init]))
   {
      position   = nil;
      context    = nil;
      searchText = nil;
      [self setPosition: _position];
      [self setContext: _context];
      [self setSearchText: _searchText];
   }
   return self;
}


/*
 * Initialize with empty properties.
 */
- (id) init
{
   return [self initWithPosition: nil context: nil searchText: nil];
}


- (void) dealloc
{
   [self setPosition: nil];
   [self setContext: nil];
   [self setSearchText: nil];

   [super dealloc];
}


/*
 * Create an (autoreleased) match with the specified
 * properties.
 */
+ (Match*) matchAt: (DocumentPosition*)_position
           context: (NSString*)_context
        searchText: (NSString*)_searchText
{
   Match* match;

   match = [[Match alloc] initWithPosition: _position
                          context: _context
                          searchText: _searchText];

   return [match autorelease];
}


/*
 * Returns the position in the document where this match
 * occured.
 */
- (DocumentPosition*) position
{
   return position;
}


/*
 * Set the position in the document where this match
 * occured.
 */
- (void) setPosition: (DocumentPosition*)_position
{
   [position release];
   position = _position;
   [position retain];
}


/*
 * Return the context of this match. This is some text
 * around the position where this match occured.
 */
- (NSString*) context
{
   return context;
}


/*
 * Set the context of this match. See context message for
 * more information.
 */
- (void) setContext: (NSString*)_context;
{
   [context release];
   context = [_context copy];
}


/*
 * Get the text that has been searched for when this
 * match occcured.
 */
- (NSString*) searchText
{
   return searchText;
}


/*
 * Set the text that has been searched for when this
 * match occcured.
 */
- (void) setSearchText: (NSString*)_searchText
{
   [searchText release];
   searchText = [_searchText copy];
}

@end
