// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: SimulationObjectProxy.cpp
// 
//---------------------------------------------------------------------------

#include "SimulationObjectProxy.h"
#include "OutputManager.h"
#include "KernelMessage.h"
#include "Event.h"
#include "EventMessage.h"
#include "NegativeEventMessage.h"
#include "SerializedInstance.h"
#include "CommunicationManager.h"
#include "TimeWarpSimulationManager.h"
#include <clutils/Debug.h>

using std::cerr;
using std::endl;

CommunicationManager *
SimulationObjectProxy::myCommunicationManagerHandle = NULL;

SimulationObjectProxy::SimulationObjectProxy( const string &initObjectName,
					      unsigned int sourceSimMgr,
					      unsigned int destSimMgr,
					      CommunicationManager *commMgr) :
  sourceSimulationManager(sourceSimMgr),
  destinationSimulationManager(destSimMgr),
  objectName( initObjectName ){
  DEBUG(
	numberOfPositiveNetworkEvents = 0;
	numberOfNegativeNetworkEvents = 0;
	)
    myCommunicationManagerHandle = commMgr;
}

SimulationObjectProxy::~SimulationObjectProxy(){
  clutils::debug << "processed (+)(" << numberOfPositiveNetworkEvents 
	<< ")(-)(" << numberOfNegativeNetworkEvents
	<< ") MPI messages" << endl;
}

void
SimulationObjectProxy::initialize(){
  cerr << "ERROR: SimulationObjectProxy::initialize called" << endl;
  abort();
}


void
SimulationObjectProxy::finalize(){
  cerr << "ERROR: SimulationObjectProxy::finalize called" << endl;
  abort();

}


void
SimulationObjectProxy::executeProcess(){
  cerr << "ERROR: SimulationManager(" << sourceSimulationManager
       << ")'s SimulationObjectProxy::executeProcess called" << endl;
  abort();

}

State*
SimulationObjectProxy::allocateState(){
  cerr << "ERROR: SimulationObjectProxy::allocateState called" << endl;
  abort();
  return NULL;
}

void
SimulationObjectProxy::deallocateState( const State * ){
  cerr << "ERROR: SimulationObjectProxy::deallocateState called" << endl;
  abort();
}

void
SimulationObjectProxy::reclaimEvent(const Event * ){
  cerr << "ERROR: SimulationObjectProxy reclaimEvent called!" << endl;
  abort();
}

const string &
SimulationObjectProxy::getEventMessageType(){
  static const string messageType = "EventMessage";
  return messageType;
}

const string &
SimulationObjectProxy::getNegativeEventMessageType(){
  static const string messageType = "NegativeEventMessage";
  return messageType;
}

void
SimulationObjectProxy::reportError( const string &, SEVERITY ){
  cerr << "ERROR: SimulationObjectProxy::reportError called" << endl;
  abort();
}
