#!/usr/local/bin/perl
# index.cgi
# Display burn profiles and icons for global options

require './burner-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("cdrecord mkisofs", "man", "doc"));

if (!&has_command($config{'cdrecord'})) {
	print "<p>",&text('index_ecdrecord', "<tt>$config{'cdrecord'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{"index"});
	exit;
	}

print "<h3>$text{'index_profiles'}</h3>\n";
@allprofiles = &list_profiles();
@profiles = grep { &can_use_profile($_) } @allprofiles;
if (@profiles) {
	&show_button();
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
	      "<td><b>$text{'index_type'}</b></td> ",
	      "<td><b>$text{'index_files'}</b></td> </tr>\n";
	foreach $p (@profiles) {
		print "<tr $cb>\n";
		print "<td><a href='edit_profile.cgi?id=$p->{'id'}'>",
		      "$p->{'name'}</a></td>\n";
		print "<td>",$text{'index_type'.$p->{'type'}},"</td>\n";
		if ($p->{'type'} == 1) {
			print "<td>$p->{'iso'}</td>\n";
			}
		elsif ($p->{'type'} == 4) {
			print "<td>$p->{'sdesc'}</td>\n";
			}
		else {
			print "<td>";
			for($i=0; defined($p->{"source_$i"}); $i++) {
				print "&nbsp;|&nbsp;\n" if ($i);
				print $p->{"source_$i"};
				}
			print "</td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
elsif (@allprofiles) {
	print "<b>$text{'index_noaccess'}</b><p>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
&show_button();

if ($access{'global'}) {
	print "<hr>\n";
	@links = ( "edit_mkisofs.cgi", "edit_dev.cgi" );
	@titles = ( $text{'mkisofs_title'}, $text{'dev_title'} );
	@icons = ( "images/mkisofs.gif", "images/dev.gif" );
	&icons_table(\@links, \@titles, \@icons);
	}

&ui_print_footer("/", $text{'index'});

sub show_button
{
if ($access{'create'}) {
	print "<form action=edit_profile.cgi>\n";
	print "<input type=submit value='$text{'index_add'}'>\n";
	print "<select name=type>\n";
	print "<option value=1 checked> $text{'index_type1'}\n";
	print "<option value=2> $text{'index_type2'}\n";
	print "<option value=3> $text{'index_type3'}\n";
	print "<option value=4> $text{'index_type4'}\n";
	print "</select></form>\n";
	}
}

