/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2003 Ron Steinke <rsteinke@w-link.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "cornercontainer.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "debug.h"

wftk::CornerContainer::CornerContainer(Corner corner, unsigned hpad, unsigned vpad) :
	SingleContainer(vpad, vpad, hpad, hpad),
	corner_(corner), hpad_(hpad), vpad_(vpad)
{
  switch(corner) {
    case TOP_LEFT: case TOP_RIGHT: case BOTTOM_LEFT: case BOTTOM_RIGHT:
      break;
    default:
      assert(false);
  }
}

void wftk::CornerContainer::handleResize(Uint16 w, Uint16 h)
{
  Widget::handleResize(w, h);

  Debug::channel(Debug::PACKING) << "Calling CornerContainer::handleResize()"
	<< Debug::endl;

  // get the area allowed to the widget
  w = (w > 2 * hpad_) ? (w - 2 * hpad_) : 0;
  h = (h > 2 * vpad_) ? (h - 2 * vpad_) : 0;

  if(child()) {
    PackingInfo info = child()->getPackingInfo();

    Rect r;

    if(info.x.pref < w) {
      r.x = hpad_ + ((corner_ & LEFT) ? 0 : w - info.x.pref);
      r.w = info.x.pref;
    }
    else {
      r.x = hpad_;
      r.w = (w > info.x.min) ? w : info.x.min;
    }

    if(info.y.pref < h) {
      r.y = vpad_ + ((corner_ & TOP) ? 0 : h - info.y.pref);
      r.h = info.y.pref;
    }
    else {
      r.y = vpad_;
      r.h = (h > info.y.min) ? h : info.y.min;
    }

    Debug::channel(Debug::PACKING) << "Resizing child of Terrain to "
	<< r << Debug::endl;

    child()->resize(r);
  }
}
