#include <stdio.h>
#include <stdlib.h>

#include "common.h"
#include "parseprg.h"
#include "prgcommon.h"

char* ScriptExec::Consume(ServerMem* Ca, Time PacketTime) {
  cache0_idx=cache1_idx=-1;
  ca=Ca; 
  packettime=PacketTime;
  packettime64=PacketTime.tv.tv_sec;

  // Calculate the time value if used by the program:
  if(ct) {
    time_t ti=PacketTime.tv.tv_sec;
    time=*localtime(&ti);
  }
  
  return execProgram();
}

int ScriptExec::GetIdIdx(card_id& ma, int insert, char*& error) {
  // Try find the card in our table:
  CardInfo c; 
  CardInfo* a;
  
  switch(cit) {
    case idIP: {
        c.ipaddr=ma.ipaddr;    
        a=(CardInfo*)bsearch(&c,&ca->cards,ca->curcardc,sizeof(CardInfo),CardInfo::compare_ip);
      }
      break;
    case idMAC: {
        c.macaddr=ma.macaddr;
        a=(CardInfo*)bsearch(&c,&ca->cards,ca->curcardc,sizeof(CardInfo),CardInfo::compare_mac);
      }
      break;
  }      

  if(a==0) {
    // The card could not be found
    if(!insert || readonly) {
      return -1;
    }

    // Insert it:

    if(ca->curcardc>=ca->maxcardc) {
      // But first we need to free the least recently used card:
      Time t;
      int j=-1;
      for(int i=0; i<ca->maxcardc; i++) {
        if(j==-1 || ca->cards[i].touched<=t) { j=i; t=ca->cards[i].touched; }
      }
      if(ca->logtablefull) {
        char buf[256];
        snprintf(buf,256,"Warning: Card with addresses %s and %s deleted because table is full",ca->cards[j].macaddr.tostr(),ca->cards[j].ipaddr.tostr());
        log_tablefull(buf);
      }
      TBLidxdel(j,error);
      assert(ca->curcardc < ca->maxcardc);
    }
       
    // Find index to insert card at:
    int i;
    
    if(cit==idIP) {
      for(i=0; i<ca->curcardc; i++)
        if(ip_addr::compare(ca->cards[i].ipaddr,ma.ipaddr)>=0) break;  
    }
    if(cit==idMAC) {
      for(i=0; i<ca->curcardc; i++)
        if(mac_addr::compare(ca->cards[i].macaddr,ma.macaddr)>=0) break;  
    }
        
    a=&ca->cards[i];
    
    // Insert the card at index i - move the other cards:
    int b;
    for(b=ca->curcardc; b>i; b--) ca->cards[b]=ca->cards[b-1];
    ca->curcardc++;
    
    // And insert the new card. 

    if(cit==idMAC)
      a->macaddr=ma.macaddr;
    else
      a->macaddr.setZero();
      
    if(cit==idIP)
      a->ipaddr=ma.ipaddr;
    else
      a->ipaddr.setZero();
      
    a->setZero();
    
    // Invalidate the cache:
    if(cache0_idx>=i) cache0_idx=-1;
    if(cache1_idx>=i) cache1_idx=-1;
  }
  
  return a-ca->cards;
}

int64* ScriptExec::TBLgetcnt(card_id m, int counter, char*& error) {  
  int i=getIdIdx(m,1,error);
  if(i==-1 || counter>=maxcounterc || counter<0) {
    if(!error) error="Tried to access invalid counter";
    static int64 default_location=0;
    return &default_location;
  }
  return &ca->cards[i].Counters[counter];
}

void ScriptExec::TBLidxdel(int idx, char*& error) {
  if(idx>=ca->curcardc || idx<0) {
    if(!error) error="Tried to delete non-existsing card";
    return;
  }

  // Copy the cards above this one position down:
  for(int i=idx+1; i<ca->curcardc; i++) {
    ca->cards[i-1]=ca->cards[i];
  }
  // Decrement the card count
  ca->curcardc--;

  // And invalidate the cache:
  if(cache0_idx>=idx) cache0_idx=-1;
  if(cache1_idx>=idx) cache1_idx=-1;  
}

mac_addr ScriptExec::TBLgetmacaddr(int idx, char*& error) {
  if(idx>=ca->curcardc || idx<0) {
    if(!error) error="MAC address for non existing card tried read";
    mac_addr a; a.setZero(); return a;
  }
  return ca->cards[idx].macaddr;
}

ip_addr ScriptExec::TBLgetipaddr(int idx, char*& error) {
  if(idx>=ca->curcardc || idx<0) {
    if(!error) error="IP address for non existing card tried read";
    ip_addr a; a.setZero(); return a;
  }
  return ca->cards[idx].ipaddr;
}

ParseProgram::types ScriptExec::getSymbol(char* name, void*& location) {
  if(!strcmp(name,"time")) { 
    location=(int64*)&packettime64; 
    return tINT64; 
  }
  if(!strcmp(name,"hour"))    { location=&time.tm_hour; ct=1; return tINT32; }
  if(!strcmp(name,"min"))     { location=&time.tm_min;  ct=1; return tINT32; }
  if(!strcmp(name,"wday"))    { location=&time.tm_wday; ct=1; return tINT32; }
  if(!strcmp(name,"mday"))    { location=&time.tm_mday; ct=1; return tINT32; }
  
  return ParseProgram::getSymbol(name,location);
}
