/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2002 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "presentacion.h"
#include "intern.h"
#include "version.h"

#include <qfile.h>
#include <qtextstream.h>

QString getIntroText() {

	QString texto= _("<qt><center><h1>Welcome to Wordtrans %1</h1></center>").arg(VERSION);

	QString fichero = _("/usr/share/doc/wordtrans-data/welcome_en.html");

	QFile f(fichero);
	if ( f.open(IO_ReadOnly) ) {
		QTextStream t( &f );
		while (!t.eof()) {
			texto += t.readLine();
		}
		f.close();
	} else {
		texto += _("<p>Error opening welcome message (file \"%1\").</p> "
                  "<p>Please, be sure you have installed wordtrans properly.</p>")
                  .arg(fichero);
	}

	texto += "</qt>";

	return texto;
}

