/* enterpathop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: enterpathop.h,v 1.8 2004/10/27 21:07:18 ralf Exp $ */

#ifndef ENTERPATHOP_H
#define ENTERPATHOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>

class EnterPathOp:public FunctionProto
{
public:
  EnterPathOp();
  virtual ~EnterPathOp();
  EnterPathOp( const EnterPathOp &other );
  EnterPathOp &operator=( const EnterPathOp &other );

  virtual EnterPathOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  typedef enum {ENTERPATHOP_THISSIDE=0,
                ENTERPATHOP_OTHERSIDE,
                ENTERPATHOP_LEFTSIDE,
                ENTERPATHOP_RIGHTSIDE} enterpath_t;
  void setSide(enterpath_t);
protected:
  static const char *name;
  // Infos to save
  enterpath_t enterpathside;

  // temp variables
  Lister *startlister;
  
  void normalmodeenterpath();
};

#endif
