/* worker_commands.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: worker_commands.cc,v 1.27 2004/10/27 21:10:16 ralf Exp $ */

#include "worker.h"
#include "worker_commands.h"

int Worker::getNrOfCommands()
{
  return WorkerLocale::getCatComEntry();
}

FunctionProto *Worker::getCommand4ID(int id)
{
  FunctionProto *fpr=NULL;
  switch(id) {
    case 1:fpr=new DoubleClickAction();
      break;
    case 2:fpr=new ShowAction();
      break;
    case 3:fpr=new RawShowAction();
      break;
    case 4:fpr=new UserAction();
      break;
    case 5:
      fpr=new RowUp();
      break;
    case 6:
      fpr=new RowDown();
      break;
    case 7:
      fpr=new ChangeHiddenFlag();
      break;
    case 8:
      fpr=new CopyOp();
      break;
    case 9:
      fpr=new FirstRow();
      break;
    case 10:
      fpr=new LastRow();
      break;
    case 11:
      fpr=new PageUp();
      break;
    case 12:
      fpr=new PageDown();
      break;
    case 13:
      fpr=new SelectOp();
      break;
    case 14:
      fpr=new SelectAllOp();
      break;
    case 15:
      fpr=new SelectNoneOp();
      break;
    case 16:
      fpr=new InvertAllOp();
      break;
    case 17:
      fpr=new ParentDirOp();
      break;
    case 18:
      fpr=new EnterDirOp();
      break;
    case 19:
      fpr=new ChangeListerSetOp();
      break;
    case 20:
      fpr=new SwitchListerOp();
      break;
    case 21:
      fpr=new FilterSelectOp();
      break;
    case 22:
      fpr=new FilterUnSelectOp();
      break;
    case 23:
      fpr=new Path2OSideOp();
      break;
    case 24:
      fpr=new QuitOp();
      break;
    case 25:
      fpr=new DeleteOp();
      break;
    case 26:
      fpr=new ReloadOp();
      break;
    case 27:
      fpr=new MakeDirOp();
      break;
    case 28:
      fpr=new OwnOp();
      break;
    case 29:
      fpr=new RenameOp();
      break;
    case 30:
      fpr=new DirSizeOp();
      break;
    case 31:
      fpr=new SimDDOp();
      break;
    case 32:
      fpr=new StartProgOp();
      break;
    case 33:
      fpr=new SearchEntryOp();
      break;
    case 34:
      fpr=new EnterPathOp();
      break;
    case 35:
      fpr=new ScrollListerOp();
      break;
    case 36:
      fpr=new CreateSymlinkOp();
      break;
    case 37:
      fpr=new ChangeSymlinkOp();
      break;
    case 38:
      fpr=new ChModOp();
      break;
    case 39:
      fpr=new ToggleListermodeOp();
      break;
    case 40:
      fpr=new SetSortmodeOp();
      break;
    case 41:
      fpr=new SetFilterOp();
      break;
    case 42:
      fpr=new ShortkeyFromListOp();
      break;
    case 43:
      fpr=new ChOwnOp();
      break;
    case 44:
      fpr=new ScriptOp();
      break;
    case 45:
      fpr = new ShowDirCacheOp();
      break;
    case 46:
      fpr = new ParentActionOp();
      break;
    case 47:
      fpr = new NoOperationOp();
      break;
    default:
      fpr=new DNDAction();
  }
  return fpr;
}

int Worker::getID4Command(FunctionProto *fpr)
{
  int type=-1;
  if(fpr->isName("DNDAction")==true) type=0;
  else if(fpr->isName("DoubleClickAction")==true) type=1;
  else if(fpr->isName("ShowAction")==true) type=2;
  else if(fpr->isName("RawShowAction")==true) type=3;
  else if(fpr->isName("UserAction")==true) type=4;
  else if(fpr->isName("RowUp")==true) type=5;
  else if(fpr->isName("RowDown")==true) type=6;
  else if(fpr->isName("ChangeHiddenFlag")==true) type=7;
  else if(fpr->isName("CopyOp")==true) type=8;
  else if(fpr->isName("FirstRow")==true) type=9;
  else if(fpr->isName("LastRow")==true) type=10;
  else if(fpr->isName("PageUp")==true) type=11;
  else if(fpr->isName("PageDown")==true) type=12;
  else if(fpr->isName("SelectOp")==true) type=13;
  else if(fpr->isName("SelectAllOp")==true) type=14;
  else if(fpr->isName("SelectNoneOp")==true) type=15;
  else if(fpr->isName("InvertAllOp")==true) type=16;
  else if(fpr->isName("ParentDirOp")==true) type=17;
  else if(fpr->isName("EnterDirOp")==true) type=18;
  else if(fpr->isName("ChangeListerSetOp")==true) type=19;
  else if(fpr->isName("SwitchListerOp")==true) type=20;
  else if(fpr->isName("FilterSelectOp")==true) type=21;
  else if(fpr->isName("FilterUnSelectOp")==true) type=22;
  else if(fpr->isName("Path2OSideOp")==true) type=23;
  else if(fpr->isName("QuitOp")==true) type=24;
  else if(fpr->isName("DeleteOp")==true) type=25;
  else if(fpr->isName("ReloadOp")==true) type=26;
  else if(fpr->isName("MakeDirOp")==true) type=27;
  else if(fpr->isName("OwnOp")==true) type=28;
  else if(fpr->isName("RenameOp")==true) type=29;
  else if(fpr->isName("DirSizeOp")==true) type=30;
  else if(fpr->isName("SimDDOp")==true) type=31;
  else if(fpr->isName("StartProgOp")==true) type=32;
  else if(fpr->isName("SearchEntryOp")==true) type=33;
  else if(fpr->isName("EnterPathOp")==true) type=34;
  else if(fpr->isName("ScrollListerOp")==true) type=35;
  else if(fpr->isName("CreateSymlinkOp")==true) type=36;
  else if(fpr->isName("ChangeSymlinkOp")==true) type=37;
  else if(fpr->isName("ChModOp")==true) type=38;
  else if(fpr->isName("ToggleListermodeOp")==true) type=39;
  else if(fpr->isName("SetSortmodeOp")==true) type=40;
  else if(fpr->isName("SetFilterOp")==true) type=41;
  else if(fpr->isName("ShortkeyFromListOp")==true) type=42;
  else if(fpr->isName("ChOwnOp")==true) type=43;
  else if(fpr->isName("ScriptOp")==true) type=44;
  else if ( fpr->isName( ShowDirCacheOp::name ) == true ) type = 45;
  else if ( fpr->isName( ParentActionOp::name ) == true ) type = 46;
  else if ( fpr->isName( NoOperationOp::name ) == true ) type = 47;
  return type;
}

int Worker::getMaxModeNr()
{
  // leider hardcoded, da aber die schlechte Methode in dieser Klasse bleibt, nicht so
  // schlimm
  return 3;
}

ListerMode *Worker::getMode4ID(int nr,Lister *parent)
{
  ListerMode *lm=NULL;
  switch(nr) {
    case 1:
      lm=new ShowImageMode(parent);
      break;
    case 2:
      lm=new InformationMode(parent);
      break;
    default:
      lm=new NormalMode(parent);
      break;
  }
  return lm;
}

const char *Worker::getNameOfMode( int nr )
{
  switch ( nr ) {
    case 1:
      return ShowImageMode::getStaticType();
      break;
    case 2:
      return InformationMode::getStaticType();
      break;
  }
  return NormalMode::getStaticType();
}

const char *Worker::getLocaleNameOfMode( int nr )
{
  switch ( nr ) {
    case 1:
      return ShowImageMode::getStaticLocaleName();
      break;
    case 2:
      return InformationMode::getStaticLocaleName();
      break;
  }
  return NormalMode::getStaticLocaleName();
}

int Worker::getID4Name( const char *str )
{
  if ( str == NULL ) return -1;
  if ( strcasecmp( str, ShowImageMode::getStaticType() ) == 0 ) return 1;
  if ( strcasecmp( str, InformationMode::getStaticType() ) == 0 ) return 2;
  if ( strcasecmp( str, NormalMode::getStaticType() ) == 0 ) return 0;
  return -1;
}

int Worker::getID4Mode(ListerMode *lm)
{
  int type=-1;
  if(lm->isType("NormalMode")==true) type=0;
  else if(lm->isType("ShowImageMode")==true) type=1;
  else if(lm->isType("InformationMode")==true) type=2;
  return type;
}

