// $Id: HeightFieldChange.h,v 1.14 2001/10/28 23:24:43 nekeme Exp $
#ifndef WE_HEIGHTFIELD_CHANGE_H
#define WE_HEIGHTFIELD_CHANGE_H

#include "Tool.h"


class HeightFieldChange : public Tool
{
  protected:
    virtual HeightFieldChange* Clone() = 0;

    /// Clone and gives the clone the current state
    inline HeightFieldChange* CloneState() {
	HeightFieldChange* clone = Clone();
	clone->m_State = m_State;
	m_State = 0;
	return clone;
    }
    
  // State information for undo/redo
  protected:
    // m_State is non-null when the operation has been used
    short* m_State;
    
    // Create the state data
    void InitState(short value);

    // Get a refernce inside the state data
    inline short& GetState(unsigned x, unsigned z) { return m_State[x + z * m_World->m_SizeX]; }

  public:
    HeightFieldChange(World* hf) : Tool(hf), m_State(0) {}
    virtual ~HeightFieldChange();

    virtual void Apply(int, int) = 0;

    virtual void Update();

  public:
    virtual std::string Type() const
       { return std::string("Heightfield change"); }

    /// Create a command with a correct state.
    virtual Command* CreateCommand() { return 0; };

};

#endif // WE_HEIGHTFIELD_CHANGE_H
