/*
 *   Copyright (C) 2002 by Phil Karn KA9Q
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AudioMixer.h"

#include <wx/log.h>
#include <wx/debug.h>

#include <complex>
using namespace std;

CAudioMixer::CAudioMixer(int sampleRate) :
m_sampleRate(sampleRate),
m_nco(sampleRate),
m_hilbert(0.05, 0.45)
{
	wxASSERT(m_sampleRate > 0);
}

CAudioMixer::~CAudioMixer()
{
}

void CAudioMixer::mix(double frequency, double* input, double* output, int length)
{
	wxASSERT(input != NULL);
	wxASSERT(output != NULL);
	wxASSERT(length > 0);

	complex<double>* osc = new complex<double>[length];
	m_nco.generate(frequency, osc, length);

	complex<double>* out = new complex<double>[length];
	m_hilbert.transform(input, out, length);

	for (int i = 0; i < length; i++) {
		complex<double> mix = osc[i] * out[i];

		if (frequency < 0.0)
			output[i] = mix.imag();
		else
			output[i] = mix.real();
	}

	delete[] osc;
	delete[] out;
}
