/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44LevelEvent_H
#define	JT44LevelEvent_H

#include <wx/wx.h>

#include "JT44Levels.h"

#include "common/Receive.h"

class CJT44LevelEvent : public wxEvent {

    public:
	CJT44LevelEvent(CJT44Levels* levels, EWho who, wxEventType type, int id = 0);
	virtual ~CJT44LevelEvent();

	virtual CJT44Levels* getLevels() const;
	virtual EWho         getWho() const;

	virtual wxEvent* Clone() const;

    protected:
	CJT44LevelEvent(const CJT44LevelEvent& event);

    private:
	CJT44Levels* m_levels;
	EWho         m_who;
};

#endif
