.\" X-BASED ABACUS
.\"
.\" xabacus.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2005	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "useful",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH ABACUS 6 "10 Jan 2005" "V7.1.3"
.SH NAME
xabacus \- Abacus X widget
.SH SYNOPSIS
.B xabacus
 [-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-frame {color}] [-rail {color}]
[-bead {color}] [-rails {int}] [-[no]slot] [-[no]diamond]
[-{chinese|japanese|korean|roman|russian}]
[-base {int}] [-displayBase {int}] [-[no]romanNumerals]
[-[no]sign] [-[no]quarter]
[-tnumber {int}] [-bnumber {int}] [-tfactor {int}]
[-bfactor {int}] [-tspaces {int}] [-bspaces {int}]
[-[no]torient] [-[no]borient] [-delay msecs]
[-[no]sound] [-bumpsound {filename}] [-movesound {filename}]
[-[no]demo] [-[no]script]
[-demopath {path}] [-demofont {fontname}]
[-demofg {color}] [-demobg {color}]
.SH DESCRIPTION
This is an implementation of the classic Chinese abacus (Saun-pan) which has
its origins in the 12th century.

The device has two decks.  Each deck, separated by a partition, normally has
13 rails on which are mounted beads.  Each rail on the top deck contains 1 or
2 beads, and each rod on the bottom deck contains 4 or 5 beads.  Each bead
on the upper deck has a value of five, while each bead on the lower deck
has value of one.  Beads are considered counted, when moved \fItowards\fP the
partition separating the decks, i.e. to add a value of one a bead in the
bottom deck is moved up and to add a value of 5 a bead in the top deck
is moved down.

The basic operations of the abacus are addition and subtraction.
Multiplication can be done by mentally doing the multiplications while
adding up the intermediate results.  Division would be similar where
the intermediate results are subtracted.  There are techniques like
using your thumb and forefinger which does not apply with mouse entry.
Also with multiplication, one can carry out calculations on different parts
of the abacus, here it is nice to have a long abacus.

The pre-WWII Japanese abacus (Soroban) (or Korean Supan) is similar to the
Chinese abacus but has only one bead per rail on the top deck.  The later
Japanese abacus was further simplified to have only 4 beads per rail on the
bottom deck.

The Roman hand-abacus predates the Chinese abacus and is very similar to
the later Japanese abacus, but seems to have fallen out of use with the
Fall of the Roman Empire (at least 3 are in existence).  The Roman abaci
are brass plates where the beads move in slots.  In addition to the normal
7 columns of beads, they generally have 2 special columns on the right
side. In two examples: the first special column was for 12ths (12 uncia
(ounces) = 1 as) and had one extra bead in the bottom deck.  Also the
last column was a combination of halves, quarters, and thirds of an ounce
and had no slot in the top deck and 4 beads at the bottom (beads did not
have to come to the top to be counted but at one of 3 marked points where
the top bead was for halves, 1 for quarters, and the bottom 2 for thirds).
In another surviving example: the 2 special columns were switched and
the combination column was broken into 3 separate slots.

The Russian abacus was invented in the 17th century, here the beads are
moved from right to left (currently the xabacus can not be oriented that
way and one has to move the beads down).  It has colored beads in the
middle for ease of use.
Quarters represent 1/4 Rubles and are only present historically on the
Russian abacus (Schoty).  Some of the older Schoty have a extra place for
the 1/4 Kopek (quarter percent) as well as the 1/4 Ruble (quarter).

The signed bead is an invention of the author and is not present on any
historical abacus (to his knowledge) and is used to represent negatives.
"New & Improved" abacus models have two auxiliary decks stacked above
the principal deck that enable multiplication, division, square-root,
and cube-root computations to be performed with equal ease as addition
and subtraction.
.SH FEATURES
Click "\fBmouse-left\fP" button on a bead you want to move.
The beads will shift themselves to vacate the row and column that was
clicked.
.LP
Click "\fBmouse-right\fP" button, or press "\fBC\fP" or "\fBc\fP" keys, to
clear the abacus.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the demo mode.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increment the number of rails.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrement the number of rails.
.LP
Press "\fBF\fP" or "\fBf\fP" keys to switch between Chinese, Japanese,
Korean, Roman, and Russian formats.
.LP
Press "\fBM\fP" or "\fBm\fP" keys to toggle Roman Numerals.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to toggle the availability of sign bead.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to toggle the availability of quarter beads.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of beads.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of beads.
.LP
Press "\fB@\fP"  key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
The abacus may be resized.  Beads will reshape depending on the room they
have.
\fIDemo Mode:\fP
In this mode, the abacus is controlled by the program.
When started with the demo option, a second window is presented that should
be placed directly below the abacus-window. Descriptive text, and user
prompts are displayed in this window.
Pressing 'q' during the demo will quit it.  Clicking the left mouse-button
with the pointer in the window will restart the demo (beginning of current
lesson).
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the abacus window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the abacus window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the abacus window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the abacus window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the foreground of the border of the beads
(resource name "\fIborderColor\fP").
.TP 8
.B \-frame \fIcolor\fP
This option specifies the foreground of the frame (resource name
"\fIframeColor\fP").
.TP 8
.B \-rail \fIcolor\fP
This option specifies the foreground of the rails (resource name
"\fIrailColor\fP").
.TP 8
.B \-bead \fIcolor\fP
This option specifies the foreground of the beads (resource name
"\fIbeadColor\fP").
.TP 8
.B \-rails \fIint\fP
This option specifies the number of rails (resource name "\fIrails\fP").
.TP 8
.B \-[no]slot
This option allows you to have either slots or rails
(resource name "\fIslot\fP").
.TP 8
.B \-[no]diamond
This option allows you to have either diamond or round beads
(resource name "\fIdiamond\fP").
.TP 8
.B \-chinese
This option specifies the format on the abacus (resource name
"\fIformat\fP") to "Chinese" for the Chinese Saun-pan.
.TP 8
.B \-japanese
This option specifies the format on the abacus (resource name
"\fIformat\fP") to "Japanese" for the Japanese post-WWII Soroban.
This is also similar to the Roman Hand Abacus.
.TP 8
.B \-korean
This option specifies the format on the abacus (resource name
"\fIformat\fP") to "Korean" for the Korean Supan or Japanese
pre-WWII Soroban.
.TP 8
.B \-roman
This option specifies the format on the abacus (resource name
"\fIformat\fP") to "Roman" for the Roman Hand Abacus, note beads
move in slots.  To complete, specify
\fIromanNumerals\fP".
.TP 8
.B \-russian
This option specifies the format on the abacus (resource name
"\fIformat\fP") to "Russian" for the Russian Schoty.  To complete, specify
\fIquarter\fP".
.TP 8
.B \-other
This option specifies the format on the abacus (resource name
"\fIformat\fP") to "Other".  This option specifies a format that is
more configurable by using resources, since there are few rules to
govern its behavior.
.TP 8
.B \-base \fIint\fP
This option specifies the base used on abacus (default is base 10)
(resource name "\fIbase\fP").  By default, one has to set the format
mode to not be Other for this to work (unless you know what you are
doing).
.TP 8
.B \-displayBase \fIint\fP
This option specifies the base displayed (default is base 10) (resource
name "\fIdisplayBase\fP").  If this is different then "\fIbase\fP"
then it is implemented using "long long" and the calculation is limited
by its bounds.  Also the fractional part does not scale with the
"\fIdisplayBase\fP" so if the "\fIdisplayBase\fP" is greater than the
"\fIbase\fP" it looses some precision.  Also no rounding is done.
.TP 8
.B \-[no]romanNumerals
This option allows you to set the the abacus to allow Roman Numerals
(resource name "\fIromanNumerals\fP").  Roman Numerals above 3999 are
normally represented with bars on top, due to ASCII constraints this
is represented instead in lower case (historically case was ignored).
Roman Numerals above 3,999,999 were not represented historically.  Roman
numerals change with displayBase in an "experimental" way.
.TP 8
.B \-[no]sign
This option allows you to set the the abacus to allow negatives
(resource name "\fIsign\fP").
.TP 8
.B \-[no]quarter
This option allows you to set the the abacus to allow quarters
(resource name "\fIquarter\fP").
.TP 8
.B \-tnumber \fIint\fP
This option specifies the number of beads on top (resource name
"\fItopNumber\fP").
.TP 8
.B \-bnumber \fIint\fP
This option specifies the number of beads on bottom (resource name
"\fIbottomNumber\fP").
.TP 8
.B \-tfactor \fIint\fP
This option specifies the multiply factor for the beads on top (resource
name "\fItopFactor\fP").
.TP 8
.B \-bfactor \fIint\fP
This option specifies the multiply factor for the  beads on bottom
(resource name "\fIbottomFactor\fP").
.TP 8
.B \-tspaces \fIint\fP
This option specifies the number of spaces on top (resource name
"\fItopSpaces\fP").
.TP 8
.B \-bspaces \fIint\fP
This option specifies the number of spaces on bottom (resource name
"\fIbottomSpaces\fP").
.TP 8
.B \-[no]torient
This option specifies the orientation of the beads on top (resource name
"\fItopOrient\fP").
.TP 8
.B \-[no]borient
This option specifies the orientation of the beads on bottom (resource name
"\fIbottomOrient\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a bead or
a group of beads one space (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding bead should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-bumpsound \fIfilename\fP
This option specifies the file for the bump sound (resource name
"\fIbumpSound\fP").
.TP 8
.B \-movesound \fIfilename\fP
This option specifies the file for the move sound (resource name
"\fImoveSound\fP").
.TP 8
.B \-[no]demo
This option specifies to run in demo mode.  In this mode, the abacus is
controlled by the current lesson (resource name "\fIdemo\fP").
When started with the demo option, a window contains descriptive text,
and user prompts are displayed in this window.  Pressing 'q' during the
demo will quit it.  Clicking the left mouse-button with the pointer in
the window will restart the demo (beginning of current lesson).
The demo uses Abacus1.les for the first Chinese Abacus lesson, Abacusjp1.les
for the first Japanese (and Roman) Abacus lesson, Abacusko1.les for the
Korean Abacus, and Abacusru1.les for the Russian Abacus.
.TP 8
.B \-[no]script
This option specifies to log application to \fIstdout\fP, every time
the user clicks to move the beads (resource name "\fIscript\fP"). The
output is a set of deck, rail, beads added or subtracted, and the number
of text lines (4).  This can be edited to add text to the lesson and used
as a new demo keeping the generated numbers and the number of lines
constant.  If you want to add a "do nothing", the first line generated
is an example of that.
For example:
"xabacus -script > Abacus5.les"
.TP 8
.B \-demopath \fIpath\fP
This option specifies the path for the demo, possibly something like
/usr/share/games/xabacus (resource name "\fIdemoPath\fP").  It initially
looks for Abacus1.les.
If it finds that, it will later look for Abacus2.les, etc.
.TP 8
.B \-demofont \fIfontstring\fP
This option specifies the font for the explanatory text that appears in
the secondary window, during the demo.  The default font is 18 point
Times-Roman (-*-times-*-r-*-*-*-180-*). The alternate font is 8x13.
.TP 8
.B \-demofg \fIcolor\fP
This option specifies the foreground of the abacus demo window (resource
name "\fIdemoForeground\fP").
.TP 8
.B \-demobg \fIcolor\fP
This option specifies the background of the abacus demo window (resource
name "\fIdemoBackground\fP").
.SH REFERENCES
Luis Fernandes  \fIhttp://www.ee.ryerson.ca/~elf/abacus/\fP
.sp
Lee Kai-chen, How to Learn Lee's Abacus, 1958, 58 pages.
.sp
Abacus Guide Book, 57 pages.
.sp
Georges Ifrah, The Universal History of Numbers, Wiley Press 2000,
pp 209-211, 288-294.
.sp
Review of the above: http://www.ams.org/notices/200201/rev-dauben.pdf
.sp
David Eugene Smith, History of Mathematics Volume II, Dover Publications,
Inc 1958, pp 156-195.\n"
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xhexagons(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2005, David Albert Bagley
.LP
Luis Fernandes, <\fIelf@ee.ryerson.ca\fP> wrote an independent program
(xabacus 1.00) with a demo mode and postscript file.  I tried, with his
permission, to take the best features of both into one program.
Also I had help with some of the abacus in the Java version by
Sarat Chandran, <\fsaratcmahadevan@yahoo.com\fP> and some of these ideas
were ported back into this X version.
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xabacus\fP
.br
\fIftp://ibiblio.org/pub/Linux/apps/math\fP
