/* Definitions of all the resources for the Mac interface to Xconq.
   Copyright (C) 1992-1998 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

#define XconqSignature 'XCNQ'

#define OkButton 1
#define CancelButton 2
#define HelpButton 3

/* The menu bar. */

#define mbMain 128

/* Menus. */

#define mApple 128
#define mFile 129
#define mEdit 130
#define mFind 131
#define mPlay 132
#define mMore 133
#define mSide 134
#define mWindows 135
#define mViewMap 136

#define mColors 137

#define mViewList 235
#define mViewCloseup 335

#define mSides 200
#define mViewWeather 201
#define mMaterialTypes 202
#define mTerrainTypes 204
#define mUnitTypes 205
#define mAITypes 206
#define mAgreements 208
#define mMagnifications 209

#define mFeatures 212
#define mOptTerrainTypes 213
#define mViewAngles 214

#define mPlanTypes 240

#define mViewText 215
#define mViewGrids 216
#define mViewColors 217
#define mViewBorders 218
#define mPlanTypePopup 240

#define mPreferencesTopics 700
#define mSmallFont 701
#define mSmallSize 702
#define mLargeFont 703
#define mLargeSize 704
#define mSideColorPopup 705
#define mSideColorUse 706

#define miNotInUse 1
#define miMainIconColor 2
#define miHalfIconColor 3
#define miIconMaskColor 4

#define mSidesPopup 707
#define mFeatPopup 708

#define mBuildPopup 710
#define mResearchPopup 711

#define mAdvanceAchieved 713

/* Menu items. */

#define miAppleAbout 1
#define miAppleHelp 2
#define miAppleInstructions 3

#define miFileNew 1
#define miFileOpen 2
#define miFileConnect 3
/* 4 */
#define miFileClose 5
#define miFileSave 6
#define miFileSaveAs 7
/* 8 */
#define miFilePreferences 9
#define miFileColors 10
/* 11 */
#define miFilePageSetup 12
#define miFilePrintWindow 13
/* 14 */
#define miFileResign 15
#define miFileQuit 16

#define miEditUndo 1
/* 2 */
#define miEditCut 3
#define miEditCopy 4
#define miEditPaste 5
#define miEditClear 6
/* 7 */
#define miEditSelectAll 8
/* 9 */
#define miEditDesign 10

#define miFindPrevious 1
#define miFindNext 2
#define miFindNextOccupant 3
/* 4 */
#define miFindLocation 5
#define miFindUnitByName 6
#define miFindDistance 7
/* 8 */
#define miFindSelected 9

#define miPlayCloseup 1
#define miPlayCityDialog 2
#define miPlayMove 3
#define miPlayReturn 4
#define miPlaySetFormation 5
/* 6 */
#define miPlayWake 7
#define miPlaySleep 8
#define miPlayReserve 9
#define miPlayDelay 10
/* 11 */
#define miPlayBuild 12
#define miPlayRepair 13
/* 14 */
#define miPlayAttack 15
#define miPlayOverrun 16
#define miPlayFire 17
#define miPlayFireInto 18
#define miPlayDetonate 19

#define miMoreGive 1
#define miMoreTake 2
#define miMoreEmbark 3
#define miMoreDisembark 4
#define miMoreDrop 5
/* 6 */				/* Can't have submenu at position 5 or 6 for some weird reason! */
#define miMoreDetach 7	/* Problem now fixed. See macmenus.c for details. */
#define miMoreDisband 8
/* 9 */
#define miMoreAddTerrain 10
#define miMoreRemoveTerrain 11
/* 12 */
#define miMorePlanTypes 13
#define miMoreAIControl 14
/* 15 */
#define miMoreRename 16
#define miMoreGiveUnit 17

#define miSideCloseup 1
#define miSideFinishedTurn 2
/* 3 */
#define miSideMoveOnClick 4
#define miSideAutoSelect 5
#define miSideAutoFinish 6
/* 7 */
#define miSideSound 8
/* 9 */
/* 10 is AI Type submenu */
#define miSideAutoResearch 11
/* 12 */
#define miSideDoctrine 13
/* 14 */
#define miSideSendMessage 15
#define miSideRename 16

#define miWindowsGame 1
#define miWindowsNotices 2
#define miWindowsHistory 3
#define miWindowsConstruction 4
#define miWindowsCommand 5
#define miWindowsResearch 6
#define miWindowsScores 7
#define miWindowsDesign 8
#define miWindowsAgreements 9
#define miWindowsWorldMap 10
/* 11 */
#define miWindowsNewMap 12
#define miWindowsNewList 13
/* 14 */
#define miWindowsFirst 15

#define miViewCloser 1
#define miViewFarther 2
#define miViewMags 3
#define miViewAngle 4
/* 5 */

#define miViewElevations 6
#define miViewPeople 7
#define miViewControl 8
#define miViewWeather 9
#define miViewMaterials 10
#define miViewTerrain 11
#define miViewDaylight 12
#define miViewCoverage 13
/* 14 */
#define miViewText 15
#define miViewGrids 16
#define miViewColors 17
#define miViewBorders 18
/* 19 */
#define miViewOffscreen 20
#define miViewMeridians 21
#define miViewWorldMap 22

#define miViewByType 1
#define miViewByName 2
#define miViewBySide 3
#define miViewByActOrder 4
#define miViewByLocation 5
/* 6 */
#define miViewCompleted 7
#define miViewIncomplete 8
#define miViewWithTransport 9
#define miViewWithCommander 10
/* 11 */
#define miViewIconSize 12
#define miListSideColors 13
#define miListDrawEmblems 14

#define miAngle15 1
#define miAngle30 2
#define miAngle90 3

#define miWeatherTemperature 1
#define miWeatherWinds 2
#define miWeatherClouds 3

#define miPlanTypeNone 1
#define miPlanTypePassive 2
#define miPlanTypeDefensive 3
#define miPlanTypeExploratory 4
#define miPlanTypeOffensive 5
#define miPlanTypeColonizing 6
#define miPlanTypeImproving 7
#define miPlanTypeRandom 8

#define miPreferencesTopicsFiles 1
#define miPreferencesTopicsMap 2
#define miPreferencesTopicsFonts 3

#define miTextUnitNames 1
#define miTextFeatureNames 2
#define miTextOptimizeFonts 3
#define miTextEraseNames 4
#define miTextDrawEmblems 5

#define miViewGrid 1
#define miViewTopline 2
#define miViewTopunit 3
#define miViewScrollBars 4
#define miViewControlPanel 5
#define miViewOtherMaps 6

#define miSideColors 1
#define miIconMasks 2
#define miBoxMasks 3
#define miTextMasks 4
#define miSolidColorTerrain 5
#define miBlinkingCurunit 6
#define miSelectionMasks 7

#define miFeatureBorders 1
#define miShoreLines 2
#define miSimpleBorders 3

#define miPreferencesTopicsOffscreen 4
#define miPreferencesTopicsImageSets 5
#define miPreferencesTopicsColorSchemes 6

#define mi9Points 1
#define mi10Points 2
#define mi12Points 3
#define mi14Points 4
#define mi18Points 5
#define mi24Points 6
#define mi36Points 7
#define mi48Points 8

#define miChicago 1
#define miCourier 2
#define miGeneva 3
#define miHelvetica 4
#define miMonaco 5
#define miNewYork 6
#define miSymbol 7
#define miTimes 8

/* Dialogs. */

#define dSplash 128

#define diSplashNew 1
#define diSplashOpen 2
#define diSplashConnect 3
#define diSplashQuit 4
#define diSplashVersion 5
#define diSplashCopyright 6
#define diSplashPicture 7

#define dNewGame 129

#define diNewGameOK 1
#define diNewGameCancel 2
#define diNewGameList 3
#define diNewGameBlurb 4
#define diNewGamePicture 5
/* 6 is a fixed pict */

#define dPlayerSetup 130

#define diPlayerSetupOK 1
#define diPlayerSetupCancel 2
#define diPlayerSetupList 3
#define diPlayerSetupAdd 4
#define diPlayerSetupRemove 5
#define diPlayerSetupAdvantage 6
#define diPlayerSetupRename 7
#define diPlayerSetupAI 8
#define diPlayerSetupRemote 9
#define diPlayerSetupExchange 10
#define diPlayerSetupAdvantageRange 14
#define diPlayerSetupConfigure 15

#define dVariants 131

#define diVariantsOK 1
#define diVariantsCancel 2
#define diVariantsText 3
#define diVariantsWorldSeen 4
#define diVariantsSeeAll 5
#define diVariantsSequential 6
#define diVariantsPeople 7
#define diVariantsEconomy 8
#define diVariantsSupply 9
#define diVariantsFirstCheckBox 10
/* and next 6 also */
#define diVariantsFirstSlider 20
/* and next 2 also */
#define diVariantsWorldSize 23
#define diVariantsRealTime 24
#define diVariantsMoreVariants 25
#define diVariantsHelp 26

#define dProgress 132

#define diProgressText 1
#define diProgressBar 2
#define diProgressCancel 3

#define dAbout 133

#define diAboutOK 1
#define diAboutVersion 2
#define diAboutCopyright 3
#define diAboutPicture 4

#define dWorldShape 134

#define diWorldShapeOK 1
#define diWorldShapeCancel 2
#define diWorldShapePicture 3
#define diWorldShapeCircumference 4
#define diWorldShapeWidth 5 
#define diWorldShapeHeight 6
#define diWorldShapeLatitude 7
#define diWorldShapeLongitude 8
#define diWorldShapeIcon 17

#define dRealTime 135

#define diRealTimeOK 1
#define diRealTimeCancel 2
#define diRealTimeForGame 3
#define diRealTimePerSide 4
#define diRealTimePerTurn 5

#define dMoreVariants 136

#define diMoreVariantsOK 1
#define diMoreVariantsCancel 2

#define dScreenDepth 137

#define diScreenDepthOK 1
#define diScreenDepthCancel 2

#define dConfigureSide 138

#define diConfigureSideOK 1
#define diConfigureSideCancel 2
#define diConfigureSideBuild 3
#define diConfigureSideResearch 4
#define diConfigureSideTreasury 5

#define dPreferences 700

#define diPrefsOK 1
#define diPrefsCancel 2
#define diPrefsPopup 3
#define diPrefsCommon 3

#define dsPreferencesFiles 701

#define diPrefsCheckpoint (diPrefsCommon + 1)
#define diPrefsEvery (diPrefsCommon + 2)
#define diPrefsInterval (diPrefsCommon + 3)
#define diPrefsTurns (diPrefsCommon + 4)
#define diPrefsStatistics (diPrefsCommon + 5)

#define diPrefsColXCpf (diPrefsCommon + 6)
#define diPrefsColXCol (diPrefsCommon + 7)
#define diPrefsColText (diPrefsCommon + 8)
#define diPrefsShowInstr (diPrefsCommon + 9)
#define diPrefsFullSize (diPrefsCommon + 10)

#define dsPreferencesMap 702

#define diPrefsGrid (diPrefsCommon + 1)
#define diPrefsNames (diPrefsCommon + 2)
#define diPrefsFeatureNames (diPrefsCommon + 3)
#define diPrefsFeatureBorders (diPrefsCommon + 4)
#define diPrefsMeridians (diPrefsCommon + 5)
#define diPrefsIncrText (diPrefsCommon + 6)
#define diPrefsIncr (diPrefsCommon + 7)
#define diPrefsSideColors (diPrefsCommon + 8)
#define diPrefsIconMasks (diPrefsCommon + 9)
#define diPrefsSolidColorTerrain (diPrefsCommon + 10)
#define diPrefsShoreLines (diPrefsCommon + 11)
#define diPrefsSimpleBorders (diPrefsCommon + 12)
#define diPrefsComplexBorders (diPrefsCommon + 13)
#define diPrefsTopLine (diPrefsCommon + 14)
#define diPrefsUnitInfo (diPrefsCommon + 15)
#define diPrefsMapsText (diPrefsCommon +16)
#define diPrefsOtherMaps (diPrefsCommon + 17)
#define diPrefsEraseNames (diPrefsCommon + 18)
#define diPrefsBoxMasks (diPrefsCommon + 19)
#define diPrefsTextMasks (diPrefsCommon + 20)
#define diPrefsMagPopup (diPrefsCommon + 26)
#define diPrefsAIRegions (diPrefsCommon + 27)
#define diPrefsScrollBars (diPrefsCommon + 28)
#define diPrefsControlPanel (diPrefsCommon + 29)

#define dsPreferencesFonts 703

#define diPrefsOptimFonts (diPrefsCommon + 1)
#define diPrefsScaledFonts (diPrefsCommon + 2)
#define diPrefsSmallFontPopup (diPrefsCommon + 3)
#define diPrefsSmallSize (diPrefsCommon + 4)
#define diPrefsSmallSizeText (diPrefsCommon + 5)
#define diPrefsSmallSizePopup (diPrefsCommon + 6)
#define diPrefsSmallFontSample (diPrefsCommon + 7)
#define diPrefsLargeFontPopup (diPrefsCommon + 8)
#define diPrefsLargeSize (diPrefsCommon + 9)
#define diPrefsLargeSizeText (diPrefsCommon + 10)
#define diPrefsLargeSizePopup (diPrefsCommon + 11)
#define diPrefsLargeFontSample (diPrefsCommon + 12)

#define dsPreferencesOffscreen 704

#define diPrefsUseHorizBuff (diPrefsCommon + 1)
#define diPrefsHorizBuff (diPrefsCommon + 2)
#define diPrefsHPixel (diPrefsCommon + 3)
#define diPrefsUseVertiBuff (diPrefsCommon + 4)
#define diPrefsVertiBuff (diPrefsCommon + 5)
#define diPrefsVPixel (diPrefsCommon + 6)
#define diPrefs256colors (diPrefsCommon + 10)

#define dsPreferencesImageSets 705

#define diPrefsUseStandIcons (diPrefsCommon + 1)
#define diPrefsUseColorIcons (diPrefsCommon + 2)
#define diPrefsColorIconsText (diPrefsCommon + 3)
#define diPrefsUnifiedCicns (diPrefsCommon + 4)
#define diPrefsUnifiedText (diPrefsCommon + 5)
#define diPrefsDrawEmblems (diPrefsCommon + 6)
#define diPrefsBlinkingUnit (diPrefsCommon + 8)
#define diPrefsAnimatedBox (diPrefsCommon + 9)
#define diPrefsSelectionMasks (diPrefsCommon + 10)
#define diPrefsSelectionBoxes (diPrefsCommon + 11)

#define dsPreferencesColorSchemes 706

#define diPrefsMainColor1 (diPrefsCommon +1)
#define diPrefsMainColor2 (diPrefsCommon +2)
#define diPrefsMainColor3 (diPrefsCommon +3)
#define diPrefsMainColor0 (diPrefsCommon +4)

#define diPrefsHalfColor1 (diPrefsCommon +5)
#define diPrefsHalfColor2 (diPrefsCommon +6)
#define diPrefsHalfColor3 (diPrefsCommon +7)
#define diPrefsHalfColor0 (diPrefsCommon +8)

#define diPrefsMaskColor1 (diPrefsCommon +9)
#define diPrefsMaskColor2 (diPrefsCommon +10)
#define diPrefsMaskColor3 (diPrefsCommon +11)
#define diPrefsMaskColor0 (diPrefsCommon +12)

#define diPrefsSplitIcon (diPrefsCommon + 18)
#define diPrefsSidesPopup (diPrefsCommon + 19)
#define diPrefsFeaturesPopup (diPrefsCommon + 20)

#define dOffscreen 800

#define diOffscreenOK 1
#define diOffscreenCancel 2
#define diOffscreenUseHorizBuff 3
#define diOffscreenHorizBuff 4
#define diOffscreenHPixel 5
#define diOffscreenUseVertiBuff 6
#define diOffscreenVertiBuff 7
#define diOffscreenVPixel 8

#define dSideColor 801

#define diSideColorOkButton 1
#define diSideColorCancelButton 2

#define diSideColorPane1 3
#define diSideColorPane2 4
#define diSideColorPane3 5

#define diSideColorPopup1 6
#define diSideColorPopup2 7
#define diSideColorPopup3 8

#define diSideColorName1 9
#define diSideColorName2 10
#define diSideColorName3 11

#define diSideColorUse1 12
#define diSideColorUse2 13
#define diSideColorUse3 14

#define diSideColorIcon1	19
#define diSideColorIcon2	20
#define diSideColorIcon3	21
#define diSideColorIcon4	22
#define diSideColorIcon5	23

#define diSideColorCyan	24
#define diSideColorGreen	25
#define diSideColorFrame	26

#define diSideColorSplit	27

#define dFeatureColor 802

#define diFeatureColorOkButton 1
#define diFeatureColorCancelButton 2

#define diFeatureColorPane 3
#define diFeatureColorPopup 4
#define diFeatureColorName 5

#define dConnectionMethod 170

#define diConnectionMethodOK 1
#define diConnectionMethodCancel 2
#define diConnectionMethodSerial 3
#define diConnectionMethodAppleTalk 4
#define diConnectionMethodTCPIP 5
#define diConnectionMethodFile 6

#define dSerialMethod 171

#define diSerialMethodOK 1
#define diSerialMethodCancel 2
#define diSerialMethodModem 3
#define diSerialMethodPrinter 4

#define dSideRename 201

#define diSideRenameOK 1
#define diSideRenameCancel 2
#define diSideRenameRandom 3
#define diSideRenameName 4
#define diSideRenameFullName 5
#define diSideRenameAcronym 6
#define diSideRenameNoun 7
#define diSideRenamePluralNoun 8
#define diSideRenameAdjective 9
#define diSideRenameEmblemName 10
#define diSideRenameColorScheme 11

#define dRename 202

#define diRenameOK 1
#define diRenameCancel 2
#define diRenameRandom 3
#define diRenameName 4
#define diRenameText 5

#define dFeatureRename 203

#define diFeatureRenameOK 1
#define diFeatureRenameCancel 2
#define diFeatureRenameType 3
#define diFeatureRenameName 4

/*
#define dCommand 204

#define diCommandOK 1
#define diCommandCancel 2
#define diCommandText 3
*/

#define dMessage 205

#define diMessageOK 1
#define diMessageCancel 2
#define diMessageText 3
#define diMessageX 4
#define diMessageTo 5

#define dFindLocation 207

#define diFindLocationOK 1
#define diFindLocationCancel 2
#define diFindLocationLabel 3
#define diFindLocationText 4

#define dFindUnit 208

#define diFindUnitOK 1
#define diFindUnitCancel 2
#define diFindUnitLabel 3
#define diFindUnitText 4

#define dBuildPlan 301

#define diBuildPlanOK 1
#define diBuildPlanCancel 2
#define diBuildPlanUnit 3
#define diBuildPlanCurNext 4
#define diBuildPlanNumber 5
#define diBuildPlanCurType 6

#define dMultiBuild 302

#define diMultiBuildBuild 1
#define diMultiBuildUnitList 2
#define diMultiBuildTypeList 3
#define diMultiBuildRunLength 4
/* 5 */
#define diMultiBuildCurType 6
#define diMultiBuildNextType 7

#define dDesignerPalette 500

#define diDesignerPaletteTPal 1
#define diDesignerPaletteUPal 2
#define diDesignerPaletteExplanation 3
#define diDesignerPaletteSide 4

#define dDesignerSave 501

#define diDesignerSaveOK 1
#define diDesignerSaveCancel 2
#define diDesignerSaveName 3
#define diDesignerSaveModule 4
#define diDesignerSaveTypes 5
#define diDesignerSaveTables 6
#define diDesignerSaveGlobals 7
#define diDesignerSaveWorld 8
#define diDesignerSaveAreas 9
#define diDesignerSaveAreaTerrain 26
#define diDesignerSaveAreaMisc 27
#define diDesignerSaveAreaWeather 28
#define diDesignerSaveAreaMaterial 29
#define diDesignerSaveAreas 9
#define diDesignerSaveAreas 9
#define diDesignerSaveSides 10
#define diDesignerSavePlayers 11
#define diDesignerSaveUnits 12
#define diDesignerSaveScoring 13
#define diDesignerSaveHistory 14
#define diDesignerSaveReshape 15
#define diDesignerSaveCompress 16
#define diDesignerSaveSideNames 17
#define diDesignerSaveSideProps 18
#define diDesignerSaveSideViews 19
#define diDesignerSaveUnitProps 20
#define diDesignerSaveUnitMoves 21
#define diDesignerSaveUnitPlans 22
#define diDesignerSaveDoctrine 25
#define diDesignerSaveUnitIds 30

#define dDesignerReshape 502

#define diDesignerReshapeOK 1
#define diDesignerReshapeCancel 2
#define diDesignerReshapeOrigWidth 3
#define diDesignerReshapeOrigHeight 4
#define diDesignerReshapeOrigWorld 5
#define diDesignerReshapeOrigSubWidth 6
#define diDesignerReshapeOrigSubHeight 7
#define diDesignerReshapeOrigSubX 8
#define diDesignerReshapeOrigSubY 9
#define diDesignerReshapeOutputSubWidth 10
#define diDesignerReshapeOutputSubHeight 11
#define diDesignerReshapeOutputSubX 12
#define diDesignerReshapeOutputSubY 13
#define diDesignerReshapeOutputWidth 14
#define diDesignerReshapeOutputHeight 15
#define diDesignerReshapeOutputWorld 16
#define diDesignerReshapeFillTerrain 17

#define dInstructions 600

#define diInstructionsTitle 1
#define diInstructionsHelp 2
#define diInstructionsText 3

#define dUnitTypeDesc 601

#define diUnitTypeDescIcon 1
#define diUnitTypeDescName 2
#define diUnitTypeDescHelp 3
#define diUnitTypeDescACP 5
#define diUnitTypeDescMP 7
#define diUnitTypeDescAvail 8
#define diUnitTypeDescNotes 9

#define dMaterialTypeDesc 602

#define diMaterialTypeDescIcon 1
#define diMaterialTypeDescName 2
#define diMaterialTypeDescHelp 3
#define diMaterialTypeDescPeople 5
#define diMaterialTypeDescAvail 7
#define diMaterialTypeDescNotes 8

#define dTerrainTypeDesc 603

#define diTerrainTypeDescIcon 1
#define diTerrainTypeDescName 2
#define diTerrainTypeDescHelp 3
#define diTerrainTypeDescElevMin 5
#define diTerrainTypeDescElevMax 7
#define diTerrainTypeDescNotes 8
#define diTerrainTypeDescTempMin 10
#define diTerrainTypeDescTempMax 12
#define diTerrainTypeDescCapacity 14
#define diTerrainTypeDescAvail 15

#define dGameModuleDesc 604

#define dWinGame 900

#define diWinGameQuit 1
#define diWinGameContinue 2

#define dLoseGame 901

#define diLoseGameQuit 1
#define diLoseGameContinue 2

#define dGameOver 902

#define diGameOverQuit 1
#define diGameOverContinue 2

#define dCity 803

#define diCityMatPanel 4
#define diCityTransportText 5
#define diCityTransportName 6
#define diCityPlanPopup 7
#define diCityAdvancePopup 8
#define diCityResearchStatus 9
#define diCityBuildPopup 10
#define diCityBuildStatus 11

#define diCityAICheck 12
#define diCityPlanCheck 13
#define diCityAdvanceCheck 14
#define diCityBuildCheck 15
#define diCityBuildRepeat 16
#define diCityBuildEdit 17

#define diCityName 18
#define diCitySize 19
#define diCityStats 20

#define diCityMatBase 16
#define diCityOccBase 41

#define diCityMaterial 89
#define diCityProduction 90
#define diCitySupply 91
#define diCityTreasury 92

#define diCityIcon 93
#define diCityClickText 94
#define diCityBuildTimes 97
#define diCityMap 98
#define diCityFacPanel 99
#define diCityOccPanel 100
#define diCityTransportIcon 101

#define dAdvance 804

#define diAdvanceMadScientist 3
#define diAdvanceBusyScientist 4
#define diAdvanceIdleScientist 5
#define diAdvanceMainText 6
#define diAdvancePopup 7
#define diAdvanceStatus 8
#define diAdvanceCheck 9

#define dGlobalAdvance 805

#define diGlobalMadScientist 3
#define diGlobalBusyScientist 4
#define diGlobalIdleScientist 5
#define diGlobalMainText 6
#define diGlobalIdleMenu 7		/* First popup menu (Idle units). */
#define diGlobalIdleNum 17		/* Its associated number of cities. */
#define diGlobalIdleStatus 27	/* Completion status of research. */
#define diGlobalIdleText 37		/* Its associated text. */
#define diGlobalMoreNote 47	
#define diGlobalDoneMenu 50
#define diGlobalIdleCheck 53
#define diGlobalAllCheck 64

#define dMeridians 806

#define diMeridiansOK 1
#define diMeridiansCancel 2
#define diMeridiansOnOff 3
#define diMeridiansInterval 4

#define dBuild 807

#define diBuildText 3
#define diBuildPopup 4
#define diBuildAuto 5
#define diBuildRepeat 6
#define diBuildEdit 7
#define diBuildTimes 8
#define diBuildWorker 9

#define dPlan 808

#define diPlanMainText 4
#define diPlanPopup 5
#define diPlanCheck 6

#define dWorldMap 809

#define diWorldMapOK 1

#define dCloseup 810

#define dSideResearch 811

#define diSideResearchClose 1
#define diSideResearchHelp 2
#define diSideResearchPopup 3
#define diSideResearchCheck 4
#define diSideResearchText1 5
#define diSideResearchText2 6
#define diSideResearchWizard 7

#define MAXPROJMENUS 9		/* Max number of project menus (excluding Idle units) and associated items. */

/* Alerts. */

#define aInitWarning 1000

#define aiInitWarningOK 1
#define aiInitWarningText 4

#define aInitError 1001

#define aiInitErrorOK 1
#define aiInitErrorText 3

#define aRunWarning 1002

#define aiRunWarningOK 1
#define aiRunWarningText 4

#define aRunError 1003

#define aiRunErrorOK 1
#define aiRunErrorText 3

#define aImagesMissing 1004

#define aNoMem 1005
#define aiNoMemOK 1

#define aQuitGame 2000

#define aiQuitGameOK 1
#define aiQuitGameCancel 2
#define aiQuitGameDontSave 3

#define aResignGame 2001

#define aiResignGameOK 1
#define aiResignGameCancel 2
#define aiResignGameWillingToDraw 3
#define aiResignGameText 4

#define aOutOfGame 2002

#define aConfirmResign 2004

#define aiConfirmResignResign 1
#define aiConfirmResignCancel 2

#define aConfirmDesign 3001

#define aiConfirmDesignOK 1
#define aiConfirmDesignCancel 2

#define aDesignerQuitGame 3002

#define aiDesignerQuitGameOK 1
#define aiDesignerQuitGameCancel 2
#define aiDesignerQuitGameDontSave 3

#define aTwoButtonAlert 4000	/* Alert box with ParamText input and both OK and Cancel buttons */
#define aOneButtonAlert 4001	/* Alert box with ParamText input and only  a single OK button */

#define aiOK 1				/* Default OK button definition */
#define aiCancel 2			/* Default Cancel button definition */

/* Generic windows. */

#define wGame 128
#define wDesign 129
#define wMap 130
#define wList 131
#define wUnitCloseup 132
#define wHistory 133
#define wConstruction 134
#define wHelp 135
#define wNotice 136
#define wCommand 137
#define wScores 138
#define wFloatFixed 139
#define wFloatResize 140
#define wInstructions 141

/* Controls. */

#define cConstructButton 128
#define cResearchButton 129
#define cRunLengthPopup 210

#define cCloseButton 130
#define cTopicsButton 131
#define cHelpButton 132
#define cPrevButton 133
#define cNextButton 134
#define cBackButton 135
#define cDevelopButton 136

#define cFeatureAddButton 401
#define cFeatureRemoveButton 402
#define cFeatureEditButton 403

/* Cursors. */

#define cOpenCross 154
#define cAllMove 155
#define cNoMove 156
#define cGrayArrow 157

#define cParens1 128
#define NUMcParens 6
#define cSynth1 139
#define NUMcSynth 8
#define cMove1 148
#define NUMcMoves 6

#define cCell 201
#define cUnit 202
#define cPeople 203
#define cMaterial 204
#define cFeature 205
#define cElevation 206
#define cTemperature 207
#define cClouds 208
#define cWinds 209
#define cView 210

#define cBord 291
#define cConn 292
#define cCoat 293

#define cSendPacket 300
#define cReceivePacket 301

#define cLeft 401
#define cRight 402
#define cDown 403
#define cUp 404

/* Patterns. */

#define pMarchingAnts 128

/* Pictures. */

#define pEmptyPict 128
#define pMapControlsBL 129
#define pMapControlsTL 130
#define pUpDownPicture 131

#define pSplashBW 2000
#define pSplashColor 2001
#define pNewGameDecor 2002

/* Strings. */

#define sFilenames 128

#define siPreferences 1
#define siLibFolder 2
#define siLibMacFolder 3
#define siResources 4
#define siSounds 5
#define siImfDir 6
#define siNews 7
#define siSavedGame 8
#define siCheckpoint 9
#define siErrorSave 10
#define siStatistics 11

#define sImagesBWFilenames 129

#define sImagesColorFilenames 130

/* Small icons. */

#define sicnWinds0 2100

#define sicnMiss 2200
#define sicnHit  2201
#define sicnKill 2202
