// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_sms_single_editor.h
// *
// * Purpose: A single list of SMS store entries that can be edited
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 28.10.2000
// *************************************************************************

#ifndef XGSM_SMS_SINGLE_EDITOR_H
#define XGSM_SMS_SINGLE_EDITOR_H

#include "xgsm_device.h"
#include "xgsm_dialogs.h"
#include "xgsm_single_editor.h"

#include <gtk--/frame.h>
#include <gtk--/clist.h>
#include <gtk--/optionmenu.h>
#include <gtk--/text.h>
#include <gtk--/entry.h>
#include <gtk--/paned.h>
#include <sigc++/signal_system.h>
#include <gsmlib/gsm_util.h>
#include <set>

namespace Xgsm
{
  // SMS store editor

  class SMSSingleEditor : public SingleEditor
  {
    // widgets that must be insensitive if no device is open
    // or the device is busy
    Gtk::Text *_messageEntry;
    Gtk::Entry *_numberEntry;
    Gtk::Paned *_paned;
    bool _recursiveVboxAllocation;

    string _smsStore;
    unsigned int _maxTextLength, _maxTelephoneLength;

    void sensitive(bool deviceIdle);
    void refresh();
    void completeEdit(bool editorClosed = false);
    void startEdit(int row);
    void stopEdit();

    // device callbacks
    void onRefresh(ResponseRef response);

    // gui callbacks
    void onTextChanged();
    void onNumberChanged();
    void onVboxAllocate(GtkAllocation *allocation);

    // inherited
    void onSelectRow(int row, int col, GdkEvent *event);
    void onUnselectRow(int row, int col, GdkEvent *event);
    void onExtendSelection();
    void onSelectAll();
    void onUnselectAll();
    void onCut();
    void onAdd();
    void onColumnClicked(gint column);

    // debugging function
#ifndef NDEBUG
    void dumpEntries();
#endif

    vector<string> getStoreNames(OpenResponse &res)
      {return res.SMSStoreNames();}

    string currentStoreName() {return _smsStore;}
    
  public:
    SMSSingleEditor(MultiEditor *multiEditor, Gtk::Frame *frame, bool isLeft);

    // functions to connect editor to device
    void open(string deviceName, string baudRate,
              string initString, bool swHandshake, string smsStore);
    void open(string fileName);

    // initialize SMS store editor (must be called if no open())
    void init();

    void copyStore(int operation, gsmlib::Ref<SingleEditor> e);

    // inherited
    void setPanedPosition(int position);
  };

};

#endif // XGSM_SMS_SINGLE_EDITOR_H
