/*
 * Copyright (C) 2003 the xmms-kde team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef __SMPEG_PLAYER__
#define __SMPEG_PLAYER__

#include <qstring.h>
#include <qstringlist.h>
#include <qlistbox.h>
#include <qvbox.h>
#include <qsize.h>
#include <qpoint.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qcheckbox.h>
#include <qevent.h>
#include <qdragobject.h>

#include "playerinterface.h"

#ifdef HAVE_SMPEG
#include <smpeg.h>

//! A playlist for the SMPEGPlayer.
/*!
  SMPEGPlayList is a playlist for the internal SMPEGPlayer. It adds controls
  to change the currently played song by clicking on its contents.
*/
class SMPEGPlayList:public QVBox {

  Q_OBJECT

 public:

  SMPEGPlayList(QPoint pos, QSize size, QPixmap *icon);

  ~SMPEGPlayList();

  //void dragEnterEvent(QDragEnterEvent* event);
  //void dropEvent(QDropEvent* event);
  
  void insertStringList(QStringList list);
  void setSelected(int, bool);
  int  getSelected();
  void clear();
  void changeItem(QString text, int index);
  void centerCurrentItem();

  void setRepeat(bool r);
  bool getRepeat();
  void setShuffle(bool s);
  bool getShuffle();

 public slots:    
    void selectionChanged();

 signals:

  void sigSelectionChanged();
    
 private:
  
  QListBox  *playListBox;
  QCheckBox *repeatBox;
  QCheckBox *shuffleBox;
};

//! An internal player based on smpeg.
/*!
  SMPEGPlayer is the implementation of an MP3 player on top of smpeg with
  the PlayerInterface. It has additional functionality to read ID3 tags.
*/
class SMPEGPlayer:public PlayerInterface {  

  Q_OBJECT

 public:

  struct id3tag {
    char field[3];
    char name[30];
    char artist[30];
    char album[30];
    char year[4];
    char comment[30];
    unsigned char genre;
  };

  SMPEGPlayer(QStringList playList, QPoint playListPos, 
	      QSize playListSize, bool readID3Tags, bool convertUnderscores,
	      bool repeat, bool shuffle,
	      QPixmap *playListIcon);
  ~SMPEGPlayer();

  virtual void startPlayer();
  virtual void exitPlayer();
  
  virtual void previous();
  virtual void play();
  virtual void pause();
  virtual void stop();
  virtual void next();

  virtual void setVolume(int volume);
  virtual void setCurrentTime(int time);  
  virtual void toggleRepeat();
  virtual void toggleShuffle();
  
  virtual int getVolume();
  virtual int getCurrentTime();
  virtual int getTrackTime();
  virtual QString getTitle();
  virtual bool getRepeat();
  virtual bool getShuffle();
  virtual bool isPlaying();
  virtual bool isPlayerRunning();

  virtual void openFileSelector();
  virtual void playlistClear();
  virtual void playlistAdd(QString filename);
  virtual void playlistAdd(QStringList filenames);

  virtual Player is() { return SMPEG; }  

  QStringList getPlayList();

  QPoint getPlayListPos();
  QSize getPlayListSize();
  
 private slots:
    void selectionChanged();

 private:
  void addFilesToPlaylist(QString files);
  void loadMPG(QString file, bool play);
  void getInfo();
  void playNext();

  QString decodeString(QString s);

  QString parse(char *d, int len = 30);
  QString readID3Tag(QString filename);

  QString title;

  QStringList playList;

  SMPEGPlayList *playListFrame;

  unsigned int listIndex;
  int volume;

  bool running;
  bool playing;
  bool stopButtonPressed;
  bool readID3Tags;
  bool convertUnderscores;

  bool inserting;

  SMPEG_Info info;
  _SMPEG *mpg;

};

/*
class SMPEGPlayListItem : public QListBoxItem {

 public:
  SMPEGPlayListItem(QString title);
  ~SMPEGPlayListItem();

  void paint(QPainter *p);

  int height(const QListBox *lb);
  int width(const QListBox *lb);

  void setText(const char *s) {
    QListBoxItem::setText(s);
  }
    
};
*/

#else

class SMPEGPlayer:public PlayerInterface {  
  
 public:
  SMPEGPlayer() {}
  ~SMPEGPlayer() {}
};

#endif

#endif
