/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_opengl_status.h"
#include "displayer_opengl_config.h"

// Since the opengl_geforce is a singleton, keep this global static object
static SingitSingleton       *opengl_status = NULL;
static SingitSingletonClass  *parent_class = NULL;

static void opengl_status_class_init (OpenGLStatusClass *klass);
static void opengl_status_init (OpenGLStatus *sstat);
static void opengl_status_destroy(GtkObject *object);
static gboolean opengl_status_after_init(SingitSingleton *single);

GtkType opengl_status_get_type (void)
{
	static GtkType opengl_status_type = 0;

	if (!opengl_status_type) {

		static const GtkTypeInfo opengl_status_info =
		{
			(gchar*) "OpenGLStatus",
			sizeof (OpenGLStatus),
			sizeof (OpenGLStatusClass),
			(GtkClassInitFunc) opengl_status_class_init,
			(GtkObjectInitFunc) opengl_status_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		opengl_status_type = gtk_type_from_name("OpenGLStatus");
		if ((opengl_status_type == GTK_TYPE_NONE) ||
			(opengl_status_type == GTK_TYPE_INVALID))
		{
			opengl_status_type = gtk_type_unique
				(TYPE_SINGIT_SINGLETON, &opengl_status_info);
		}
		else { parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON); }
	}

	return opengl_status_type;
}

static void opengl_status_class_init (OpenGLStatusClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	SingitSingletonClass *singleton_class =
		(SingitSingletonClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_SINGLETON);

	object_class->destroy = opengl_status_destroy;
	singleton_class->after_init = opengl_status_after_init;
}

static void opengl_status_init(OpenGLStatus *sstat)
{
	sstat->gl_area_widget = NULL;

	sstat->hide_mouse_id = 0;
	sstat->jump_to_song = 0;
	sstat->time = 0;
	sstat->song = NULL;

	sstat->stereo_bass[0][0] = 0;
	sstat->stereo_bass[0][1] = 0;
	sstat->stereo_bass[1][0] = 0;
	sstat->stereo_bass[1][1] = 0;

	sstat->rotate = TRUE;

	sstat->display_list = 0;

	sstat->beat = FALSE;

	sstat->level[0] = 0;
	sstat->level[1] = 0;
	sstat->level[2] = 0;

	sstat->sfc = NULL;

	sstat->config = NULL;
}

static void opengl_status_destroy(GtkObject *object)
{
	OpenGLStatus *sstat;

	g_return_if_fail(object != NULL);
	g_return_if_fail(IS_OPENGL_STATUS (object));

	sstat = OPENGL_STATUS(object);

	if (sstat->sfc != NULL) {
		gtk_object_destroy(GTK_OBJECT(sstat->sfc));
		sstat->sfc = NULL;
	}

	singit_song_detach(&sstat->song);

	singit_config_gen_detach(&sstat->config);

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}

static gboolean opengl_status_after_init(SingitSingleton *single)
{
	g_return_val_if_fail(single != NULL, FALSE);
	g_return_val_if_fail(IS_OPENGL_STATUS(single), FALSE);

	OPENGL_STATUS(single)->config =
		displayer_opengl_config_new();
	singit_config_gen_load(OPENGL_STATUS(single)->config);

	return (OPENGL_STATUS(single)->config != NULL);
}

SingitSingleton* opengl_status_ref(void)
{
	gboolean init;
	SingitSingleton *status = singit_singleton_construct
		(&opengl_status, TYPE_OPENGL_STATUS, &init);
	if (init == TRUE)
		{ return status; }
	return singit_singleton_attach(status);
}

void opengl_status_unref(SingitSingleton** single)
{
	g_return_if_fail(opengl_status != NULL);

	if (single == NULL) {
		SingitSingleton* unref_single = opengl_status;
		singit_singleton_detach(&unref_single);
	}
	else {
		g_return_if_fail(*single == opengl_status);
		singit_singleton_detach(single);
	}
}

SingitSingleton* opengl_status_noref(void)
{
	if (opengl_status == NULL)
		{ return NULL; }

	g_return_val_if_fail(IS_OPENGL_STATUS(opengl_status), NULL);

	return opengl_status;
}
