
#ifndef __VIDEO_EXPORTER_H__
#define __VIDEO_EXPORTER_H__

#include "Eg Common.h"

#if EG_MAC
#include <QuicktimeComponents.h>
#include <MoviesFormat.h>
#include <Movies.h>
#endif

#include "VideoDevice.h"


class VideoExporter : public VideoDevice {


	public:
									VideoExporter();
		virtual						~VideoExporter();


		void 						StartExport( PixPort& inSample );
		void						EndExport();

		inline bool					Exporting() 					{	return mExporting; }



	protected:



		virtual void				TransferBits( PixPort& inFrame, Rect& inSrce, Rect& inDest );


		bool						mNeedToStartSeq;
		bool						mExporting;
		//long						mStartT;

		#if EG_MAC
		short						mMovieRefNum;
		ComponentInstance 			mComponent;
		SCTemporalSettings			mTimeSettings;
		ImageDescription**			mImageDesc;
		Movie						mMovie;
		Track						mTrack;
		Media						mMedia;
		SFReply						mDestFile;
		#endif
};

#endif // __VIDEO_EXPORTER_H__
