
#ifndef __X_STR_LIST_H__
#define __X_STR_LIST_H__

#include "AbstractStrList.h"


enum DupeOptionT {
	cDupesAllowed,
	cNoDupes_CaseInsensitive,
	cNoDupes_CaseSensitive
};


class XStrList : public AbstractStrList {

public:
	XStrList( XStrListOptsT inOption, DupeOptionT inDupeOption = cDupesAllowed );
	virtual ~XStrList();

	// Returns what index the copy of the given string now occupies (1-based indexing).  If 0 is returned,
	// a copy of the string was not added because it was a duplicate (if that flag is on)
	long				Add( const void* inData, long inLen );
	long				Add( const char* inStr );
	long				Add( const UtilStr& inStr );

	// See AbstractStrAccess.h
	virtual const UtilStr*		Fetch( long inIndex ) const		{ return (UtilStr*) mItems.Fetch( inIndex );	}

	// Allows editing of a string.  Don't have sorting on or noDupes on if you call this!!
	UtilStr*			Edit( long inIndex ) const		{ return (UtilStr*) mItems.Fetch( inIndex );	}

protected:
	virtual void			DeleteItem( void* inPtr )											{ delete (UtilStr*) inPtr;						}

	static int			sStrComparitor( const void* inA, const void* inB, const void* inPtr );

	DupeOptionT			mDupeOption;
};

// long XStrList::FindIndexOf( const UtilStr& inStr ) const

#endif // __X_STR_LIST_H__
