
#if P_SZ == 1
	#define BITS 8
	#define PIXTYPE unsigned char
#elif P_SZ == 2
	#define BITS 16
	#define PIXTYPE unsigned short
#elif P_SZ == 4
	#define BITS 32
	#define PIXTYPE unsigned long
#endif

#define __out_char_func_head(bits) \
	static void mfl_OutChar##bits(const mfl_context cx, long x, long y, char c) {

#if P_SZ == 1
__out_char_func_head(8)
#elif P_SZ == 2
__out_char_func_head(16)
#elif P_SZ == 4
__out_char_func_head(32)
#endif
	int i;
	int rows;
	unsigned char smask, j;
	unsigned char *fp;

	// Display row start, end and paint position
	unsigned char *dp_rs, *dp_re;
	PIXTYPE *dpp;

	if (cx->font == NULL)
		{ return; }

	// * Setup pointers *
	fp = cx->font->data + (cx->font->height * c);

	if (y < 0) {
		rows = cx->font->height + y;
		fp -= y;
		y = 0;
	}
	else {
		rows = cx->font->height;
	}

	if (y + rows >= (int) cx->height) {
		rows = cx->height - y;
	}

	if (rows <= 0)
		{ return; }

	smask = 0x80;
	if (x < 0) {
		smask >>= -x;
		x = 0;
		if (smask == 0)
			{ return; }
	}

	// Offset in buffer to start and end of the row
	dp_rs = (unsigned char *) cx->buf + (y * cx->bpl) + x * P_SZ;
	dp_re = dp_rs + (cx->width - x) * P_SZ;

	// * Do it *
	for (i = 0; i < rows; i++) {
		// Set the paint position
		dpp = (PIXTYPE*) dp_rs;
		for (j = smask; j > 0 && dpp < (PIXTYPE*) dp_re; j >>= 1) {
			if (*fp & j) {
				switch(cx->opmode) {
				case MFL_XOR: *dpp ^= (PIXTYPE) cx->color; break;
				case MFL_OR: *dpp |= (PIXTYPE) cx->color; break;
				case MFL_SETALL: *dpp = (PIXTYPE) 0xffffffff; break;
				// * If we don't recognize the style, revert to normal *
				default: *dpp = (PIXTYPE) cx->color; break;
				}
			}
			dpp++;
		}
		fp++;

		// Next line
		dp_rs += cx->bpl;
		dp_re += cx->bpl;
	}
}


#if P_SZ == 1
static void mfl_OutText8L(const mfl_context cx, long x, long y, const char *s, int l) {
#elif P_SZ == 2
static void mfl_OutText16L(const mfl_context cx, long x, long y, const char *s, int l) {
#elif P_SZ == 4
static void mfl_OutText32L(const mfl_context cx, long x, long y, const char *s, int l) {
#endif
	const char *esp = s + l;

	while (s < esp) {
#if P_SZ == 1
		mfl_OutChar8(cx, x, y, *s);
#elif P_SZ == 2
		mfl_OutChar16(cx, x, y, *s);
#elif P_SZ == 4
		mfl_OutChar32(cx, x, y, *s);
#endif
		s++;
		x += 8;
	}
}

#undef BITS
#undef PIXTYPE
